/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.io.BlockPointer;

public class Item {
    protected byte[] buffer;
    protected int bufferOffset;
    protected LeafNode block;
    protected ItemHead header;

    public Item(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) {
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.block = block;
        this.header = header;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] aBuffer) {
        this.buffer = aBuffer;
    }

    public int getBufferOffset() {
        return this.bufferOffset;
    }

    public void setBufferOffset(int aBufferOffset) {
        this.bufferOffset = aBufferOffset;
    }

    public LeafNode getBlock() {
        return this.block;
    }

    public void setBlock(LeafNode aBlock) {
        this.block = aBlock;
    }

    public ItemHead getHeader() {
        return this.header;
    }

    public void setHeader(ItemHead aHeader) {
        this.header = aHeader;
    }

    public BlockPointer getBlockPointer() {
        BlockPointer bp = new BlockPointer();
        bp.setBlockNum(this.block.getBlockNum());
        bp.setOffset(this.header.getItemLocation());
        bp.setLength(this.header.getItemLen());
        bp.setBlockSize(this.block.getSuperBlock().getBlockSize());
        return bp;
    }

    public byte[] getRawData() {
        byte[] newbuf = new byte[this.header.getItemLen()];
        System.arraycopy(this.buffer, this.bufferOffset + this.header.getItemLocation(), newbuf, 0, this.header.getItemLen());
        return newbuf;
    }
}

