/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.Key;
import rossi.fstools.fs.reiserfs.KeyV1;
import rossi.fstools.fs.reiserfs.KeyV2;

public class ItemHead
implements DiskStructure {
    protected Key key;
    protected int freeEntCt;
    protected int itemLen;
    protected int itemLocation;
    protected int itemVersion;

    public int getDataSize() {
        return 24;
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key aKey) {
        this.key = aKey;
    }

    public int getFreeEntCt() {
        return this.freeEntCt;
    }

    public void setFreeEntCt(int aFreeEntCt) {
        this.freeEntCt = aFreeEntCt;
    }

    public int getItemLen() {
        return this.itemLen;
    }

    public void setItemLen(int aItemLen) {
        this.itemLen = aItemLen;
    }

    public int getItemLocation() {
        return this.itemLocation;
    }

    public void setItemLocation(int aItemLocation) {
        this.itemLocation = aItemLocation;
    }

    public int getItemVersion() {
        return this.itemVersion;
    }

    public void setItemVersion(int aItemVersion) {
        this.itemVersion = aItemVersion;
    }

    public void loadFromBuffer(byte[] buffer, int blkoffset) throws FsException {
        Key k;
        this.setItemVersion(FsUtils.getU16(buffer, blkoffset + 22));
        if (this.getItemVersion() == 0) {
            k = new KeyV1();
            k.loadFromBuffer(buffer, blkoffset + 0);
        } else {
            try {
                k = new KeyV2();
                k.loadFromBuffer(buffer, blkoffset + 0);
            }
            catch (FsException ex) {
                k = new KeyV1();
                k.loadFromBuffer(buffer, blkoffset + 0);
            }
        }
        this.setKey(k);
        this.setFreeEntCt(FsUtils.getU16(buffer, blkoffset + 16));
        this.setItemLen(FsUtils.getU16(buffer, blkoffset + 18));
        this.setItemLocation(FsUtils.getU16(buffer, blkoffset + 20));
    }
}

