/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.reiserfs.DirectItem;
import rossi.fstools.fs.reiserfs.DirectoryItem;
import rossi.fstools.fs.reiserfs.FBlock;
import rossi.fstools.fs.reiserfs.IndirectItem;
import rossi.fstools.fs.reiserfs.Item;
import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.Key;
import rossi.fstools.fs.reiserfs.ReiserSuperBlock;
import rossi.fstools.fs.reiserfs.StatDataItem;

public class LeafNode
extends FBlock {
    protected ItemHead[] itemHeaders;

    public LeafNode(ReiserSuperBlock sb, int blocknum) {
        super(sb, blocknum);
    }

    public ItemHead[] getItemHeaders() {
        return this.itemHeaders;
    }

    public void setItemHeaders(ItemHead[] aItemHeaders) {
        this.itemHeaders = aItemHeaders;
    }

    public Item getItem(byte[] buffer, int offset, Key key) throws FsException {
        for (int i = 0; i < this.itemHeaders.length; ++i) {
            if (this.itemHeaders[i].getKey().compareTo(key) > 0) continue;
            return this.getItem(buffer, offset, this.itemHeaders[i]);
        }
        return null;
    }

    public Item getItem(byte[] buffer, int offset, ItemHead ih) throws FsException {
        switch (ih.getKey().getType()) {
            case 3: {
                DirectoryItem itm = new DirectoryItem(buffer, offset, this, ih);
                return itm;
            }
            case 0: {
                StatDataItem itm = StatDataItem.create(buffer, offset, this, ih);
                return itm;
            }
            case 1: {
                IndirectItem itm = new IndirectItem(buffer, offset, this, ih);
                return itm;
            }
            case 2: {
                DirectItem itm = new DirectItem(buffer, offset, this, ih);
                return itm;
            }
        }
        throw new FsException("Unsupported item type: " + ih.getKey().getType());
    }

    public void loadFromBuffer(byte[] buffer, int blkoffset) throws FsException {
        super.loadFromBuffer(buffer, blkoffset);
        this.itemHeaders = new ItemHead[this.getNumItems()];
        int ihsize = new ItemHead().getDataSize();
        int offset = blkoffset + this.getBlockHeaderSize();
        for (int i = 0; i < this.getNumItems(); ++i) {
            ItemHead ih = new ItemHead();
            ih.loadFromBuffer(buffer, offset + i * ihsize);
            this.itemHeaders[i] = ih;
        }
    }
}

