/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.SuperBlock;

public class ReiserSuperBlock
implements SuperBlock {
    protected long blockCount;
    protected long freeBlocks;
    protected long rootBlock;
    protected long journalBlock;
    protected long journalDev;
    protected long origJournalSize;
    protected long journalTransMax;
    protected long journalBlockCount;
    protected long journalMaxBatch;
    protected long journalCommitAge;
    protected long journalTransAge;
    protected int blockSize;
    protected int oldMaxSize;
    protected int currSize;
    protected int state;
    protected byte[] magic;
    protected long hashFunc;
    protected int treeHeight;
    protected int bitmapBlocks;
    protected int version;
    protected int reserved;
    protected long inodeGen;
    protected long flags;
    protected byte[] uniqueID;
    protected byte[] label;

    public int getDataSize() {
        return 204;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(long aBlockCount) {
        this.blockCount = aBlockCount;
    }

    public long getFreeBlocks() {
        return this.freeBlocks;
    }

    public void setFreeBlocks(long aFreeBlocks) {
        this.freeBlocks = aFreeBlocks;
    }

    public long getRootBlock() {
        return this.rootBlock;
    }

    public void setRootBlock(long aRootBlock) {
        this.rootBlock = aRootBlock;
    }

    public long getJournalBlock() {
        return this.journalBlock;
    }

    public void setJournalBlock(long aJournalBlock) {
        this.journalBlock = aJournalBlock;
    }

    public long getJournalDev() {
        return this.journalDev;
    }

    public void setJournalDev(long aJournalDev) {
        this.journalDev = aJournalDev;
    }

    public long getOrigJournalSize() {
        return this.origJournalSize;
    }

    public void setOrigJournalSize(long aOrigJournalSize) {
        this.origJournalSize = aOrigJournalSize;
    }

    public long getJournalTransMax() {
        return this.journalTransMax;
    }

    public void setJournalTransMax(long aJournalTransMax) {
        this.journalTransMax = aJournalTransMax;
    }

    public long getJournalBlockCount() {
        return this.journalBlockCount;
    }

    public void setJournalBlockCount(long aJournalBlockCount) {
        this.journalBlockCount = aJournalBlockCount;
    }

    public long getJournalMaxBatch() {
        return this.journalMaxBatch;
    }

    public void setJournalMaxBatch(long aJournalMaxBatch) {
        this.journalMaxBatch = aJournalMaxBatch;
    }

    public long getJournalCommitAge() {
        return this.journalCommitAge;
    }

    public void setJournalCommitAge(long aJournalCommitAge) {
        this.journalCommitAge = aJournalCommitAge;
    }

    public long getJournalTransAge() {
        return this.journalTransAge;
    }

    public void setJournalTransAge(long aJournalTransAge) {
        this.journalTransAge = aJournalTransAge;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int aBlockSize) {
        this.blockSize = aBlockSize;
    }

    public int getOldMaxSize() {
        return this.oldMaxSize;
    }

    public void setOldMaxSize(int aOldMaxSize) {
        this.oldMaxSize = aOldMaxSize;
    }

    public int getCurrSize() {
        return this.currSize;
    }

    public void setCurrSize(int aCurrSize) {
        this.currSize = aCurrSize;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int aState) {
        this.state = aState;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public void setMagic(byte[] aMagic) {
        this.magic = aMagic;
    }

    public long getHashFunc() {
        return this.hashFunc;
    }

    public void setHashFunc(long aHashFunc) {
        this.hashFunc = aHashFunc;
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public void setTreeHeight(int aTreeHeight) {
        this.treeHeight = aTreeHeight;
    }

    public int getBitmapBlocks() {
        return this.bitmapBlocks;
    }

    public void setBitmapBlocks(int aBitmapBlocks) {
        this.bitmapBlocks = aBitmapBlocks;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int aVersion) {
        this.version = aVersion;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int aReserved) {
        this.reserved = aReserved;
    }

    public long getInodeGen() {
        return this.inodeGen;
    }

    public void setInodeGen(long aInodeGen) {
        this.inodeGen = aInodeGen;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long aFlags) {
        this.flags = aFlags;
    }

    public byte[] getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(byte[] aUniqueID) {
        this.uniqueID = aUniqueID;
    }

    public byte[] getLabel() {
        return this.label;
    }

    public void setLabel(byte[] aLabel) {
        this.label = aLabel;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        if (buffer.length < offset + 116) {
            throw new FsException("Insufficinet buffer to load super-block");
        }
        this.setBlockCount(FsUtils.getU32(buffer, offset + 0));
        this.setFreeBlocks(FsUtils.getU32(buffer, offset + 4));
        this.setRootBlock(FsUtils.getU32(buffer, offset + 8));
        this.setJournalBlock(FsUtils.getU32(buffer, offset + 12));
        this.setJournalDev(FsUtils.getU32(buffer, offset + 16));
        this.setOrigJournalSize(FsUtils.getU32(buffer, offset + 20));
        this.setJournalTransMax(FsUtils.getU32(buffer, offset + 24));
        this.setJournalBlockCount(FsUtils.getU32(buffer, offset + 28));
        this.setJournalMaxBatch(FsUtils.getU32(buffer, offset + 32));
        this.setJournalCommitAge(FsUtils.getU32(buffer, offset + 36));
        this.setJournalTransAge(FsUtils.getU32(buffer, offset + 40));
        this.setBlockSize(FsUtils.getU16(buffer, offset + 44));
        this.setOldMaxSize(FsUtils.getU16(buffer, offset + 46));
        this.setCurrSize(FsUtils.getU16(buffer, offset + 48));
        this.setState(FsUtils.getU16(buffer, offset + 50));
        this.magic = new byte[12];
        System.arraycopy(buffer, offset + 52, this.magic, 0, 12);
        this.setHashFunc(FsUtils.getU32(buffer, offset + 64));
        this.setTreeHeight(FsUtils.getU16(buffer, offset + 68));
        this.setBitmapBlocks(FsUtils.getU16(buffer, offset + 70));
        this.setVersion(FsUtils.getU16(buffer, offset + 72));
        this.setReserved(FsUtils.getU16(buffer, offset + 74));
        this.setInodeGen(FsUtils.getU32(buffer, offset + 76));
        this.setFlags(FsUtils.getU32(buffer, offset + 80));
        this.uniqueID = new byte[16];
        System.arraycopy(buffer, offset + 84, this.uniqueID, 0, 16);
        this.label = new byte[16];
        System.arraycopy(buffer, offset + 100, this.label, 0, 16);
        try {
            String magics = new String(this.magic, "ISO-8859-1");
            if (this.version == 1 && !magics.startsWith("ReIsErFs")) {
                throw new FsException("Invalid magic for version 1 " + this.magic);
            }
            if (this.version == 2 && !magics.startsWith("ReIsEr2Fs")) {
                throw new FsException("Invalid magic for version 1 " + this.magic);
            }
            if (this.version > 2 || this.version < 1) {
                throw new FsException("Unsupported version " + this.version);
            }
        }
        catch (Exception ex) {
            FsException fex = new FsException("Error processing superblock.");
            fex.initCause(ex);
            throw fex;
        }
    }
}

