/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import rossi.fstools.io.BlockCache;
import rossi.fstools.io.BlockReader;

public class BlockIO
implements BlockReader {
    protected RandomAccessFile file;
    protected int blockSize;
    protected BlockCache cache;
    protected long offset;
    private static final int CACHE_SIZE = 10;

    public BlockIO(RandomAccessFile f, int blockSize) {
        this(f, blockSize, 0L);
    }

    public BlockIO(RandomAccessFile f, int blockSize, long offset) {
        this.file = f;
        this.blockSize = blockSize;
        this.offset = offset;
        this.cache = new BlockCache(10);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public synchronized void setBlockSize(int aBlockSize) {
        this.cache.clearCache();
        this.blockSize = aBlockSize;
    }

    private byte[] getBlockFromCache(int blkno) {
        return (byte[])this.cache.getBlockFromCache(blkno);
    }

    private byte[] getBlockFromDisk(int blkno) throws IOException {
        byte[] buffer = new byte[this.blockSize];
        this.file.seek((long)blkno * (long)this.blockSize + this.offset);
        this.file.readFully(buffer);
        this.cache.addBlockToCache(blkno, buffer);
        return buffer;
    }

    public synchronized byte[] getBlock(int blkno) throws IOException {
        byte[] buffer = this.getBlockFromCache(blkno);
        if (buffer == null) {
            buffer = this.getBlockFromDisk(blkno);
        }
        return buffer;
    }

    public void close() throws IOException {
        this.file.close();
    }
}

