/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import rossi.fstools.io.BlockPointer;
import rossi.fstools.io.BlockReader;

public class BlockPointerInputStream
extends InputStream {
    protected List blocks;
    protected BlockReader reader;
    protected int currentBlock;
    protected int currentBlockNum;
    protected int currentOffset;
    protected int bufferHead;
    protected byte[] currentBuffer;
    protected boolean isEOF = false;

    public BlockPointerInputStream(BlockReader reader, List blockList) {
        this.reader = reader;
        this.blocks = blockList;
        this.currentBlock = 0;
        this.currentOffset = 0;
    }

    public Iterator getBlocks() {
        return this.blocks.iterator();
    }

    public synchronized int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.isEOF) {
            throw new EOFException();
        }
        if (this.currentBlock == this.blocks.size()) {
            this.isEOF = true;
            return -1;
        }
        BlockPointer bp = (BlockPointer)this.blocks.get(this.currentBlock);
        int blockSize = bp.getBlockSize();
        int blocknum = this.currentOffset / blockSize;
        if (this.currentBuffer == null || blocknum != this.currentBlockNum) {
            if (this.reader.getBlockSize() != blockSize) {
                throw new IOException("Block size mismatch");
            }
            this.currentBuffer = this.reader.getBlock(bp.getBlockNum() + this.currentOffset / blockSize);
            this.currentBlockNum = blocknum;
            this.bufferHead = this.currentOffset < blockSize ? bp.getOffset() : 0;
        }
        if (len > blockSize - this.currentOffset % blockSize - this.bufferHead) {
            len = blockSize - this.currentOffset % blockSize - this.bufferHead;
        }
        if (len >= bp.getLength() - this.currentOffset) {
            int readlen = bp.getLength() - this.currentOffset;
            System.arraycopy(this.currentBuffer, this.bufferHead + this.currentOffset % blockSize, buffer, offset, readlen);
            this.currentBuffer = null;
            ++this.currentBlock;
            this.currentOffset = 0;
            return readlen;
        }
        System.arraycopy(this.currentBuffer, this.bufferHead + this.currentOffset % blockSize, buffer, offset, len);
        this.currentOffset += len;
        return len;
    }

    public synchronized int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public synchronized int read() throws IOException {
        byte[] buffer = new byte[1];
        int bytesRead = this.read(buffer);
        if (bytesRead == -1) {
            return -1;
        }
        return buffer[0];
    }
}

