/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.partition;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;

public class Partition
implements DiskStructure {
    protected byte boot;
    protected byte startHead;
    protected byte startSector;
    protected byte startCyl;
    protected byte system;
    protected byte endHead;
    protected byte endSector;
    protected byte endCyl;
    protected long startLBA;
    protected long numLBASector;
    public static final byte DOS_EXTENDED_PARTITION = 5;
    public static final byte LINUX_EXTENDED_PARTITION = -123;
    public static final byte WIN98_EXTENDED_PARTITION = 15;

    public byte getBoot() {
        return this.boot;
    }

    public void setBoot(byte aBoot) {
        this.boot = aBoot;
    }

    public byte getStartHead() {
        return this.startHead;
    }

    public void setStartHead(byte aStartHead) {
        this.startHead = aStartHead;
    }

    public byte getStartSector() {
        return this.startSector;
    }

    public void setStartSector(byte aStartSector) {
        this.startSector = aStartSector;
    }

    public byte getStartCyl() {
        return this.startCyl;
    }

    public void setStartCyl(byte aStartCyl) {
        this.startCyl = aStartCyl;
    }

    public byte getSystem() {
        return this.system;
    }

    public void setSystem(byte aSystem) {
        this.system = aSystem;
    }

    public byte getEndHead() {
        return this.endHead;
    }

    public void setEndHead(byte aEndHead) {
        this.endHead = aEndHead;
    }

    public byte getEndSector() {
        return this.endSector;
    }

    public void setEndSector(byte aEndSector) {
        this.endSector = aEndSector;
    }

    public byte getEndCyl() {
        return this.endCyl;
    }

    public void setEndCyl(byte aEndCyl) {
        this.endCyl = aEndCyl;
    }

    public long getStartLBA() {
        return this.startLBA;
    }

    public void setStartLBA(long aStartLBA) {
        this.startLBA = aStartLBA;
    }

    public long getNumLBASector() {
        return this.numLBASector;
    }

    public void setNumLBASector(long aNumLBASector) {
        this.numLBASector = aNumLBASector;
    }

    public boolean isExtended() {
        return this.system == 5 || this.system == -123 || this.system == 15;
    }

    public int getDataSize() {
        return 16;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        this.setBoot(buffer[offset + 0]);
        this.setStartHead(buffer[offset + 1]);
        this.setStartSector(buffer[offset + 2]);
        this.setStartCyl(buffer[offset + 3]);
        this.setSystem(buffer[offset + 4]);
        this.setEndHead(buffer[offset + 5]);
        this.setEndSector(buffer[offset + 6]);
        this.setEndCyl(buffer[offset + 7]);
        this.setStartLBA(FsUtils.getU32(buffer, offset + 8));
        this.setNumLBASector(FsUtils.getU32(buffer, offset + 12));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getBoot() == 128 ? "* " : " ");
        sb.append("\t0x");
        sb.append(Integer.toHexString(this.getSystem() & 0xFF));
        sb.append("\t");
        sb.append(Long.toString(this.getStartLBA()));
        sb.append("\t");
        sb.append(Long.toString(this.getNumLBASector()));
        return sb.toString();
    }
}

