/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rossi.fstools.fs.FsException;
import rossi.fstools.io.BlockReader;
import rossi.fstools.partition.Partition;
import rossi.fstools.partition.PartitionTable;

public class PhysicalDisk {
    protected BlockReader blockReader;

    public void open(BlockReader blockReader) {
        this.blockReader = blockReader;
    }

    public void close() throws IOException {
        this.blockReader.close();
    }

    protected void loadLogicalPartitions(List partitionList, PartitionTable logicalContainer, long tableOffset, Partition extendedPartition) throws IOException, FsException {
        Partition[] parts = logicalContainer.getPartitions();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].getNumLBASector() == 0L) continue;
            if (parts[i].isExtended()) {
                PartitionTable nextLogicalContainer = new PartitionTable();
                long nextTableOffset = extendedPartition.getStartLBA() + parts[i].getStartLBA();
                byte[] ptbl = this.blockReader.getBlock((int)nextTableOffset);
                nextLogicalContainer.loadFromBuffer(ptbl, 0);
                this.loadLogicalPartitions(partitionList, nextLogicalContainer, nextTableOffset, extendedPartition);
                continue;
            }
            parts[i].setStartLBA(parts[i].getStartLBA() + tableOffset);
            partitionList.add(parts[i]);
        }
    }

    public Partition[] getPartitions() throws IOException, FsException {
        PartitionTable mbrTable = new PartitionTable();
        ArrayList<Partition> partitionList = new ArrayList<Partition>();
        Partition extendedPartition = null;
        this.blockReader.setBlockSize(512);
        byte[] mbr = this.blockReader.getBlock(0);
        mbrTable.loadFromBuffer(mbr, 0);
        Partition[] primaryParts = mbrTable.getPartitions();
        for (int i = 0; i < primaryParts.length; ++i) {
            if (primaryParts[i].isExtended()) {
                extendedPartition = primaryParts[i];
            }
            partitionList.add(primaryParts[i]);
        }
        if (extendedPartition != null) {
            PartitionTable logicalContainer = new PartitionTable();
            byte[] ptbl = this.blockReader.getBlock((int)extendedPartition.getStartLBA());
            logicalContainer.loadFromBuffer(ptbl, 0);
            this.loadLogicalPartitions(partitionList, logicalContainer, extendedPartition.getStartLBA(), extendedPartition);
        }
        return partitionList.toArray(new Partition[0]);
    }
}

