/*
 * $Id: DiskStructure.java,v 1.4 2004/04/05 20:38:33 wrossi Exp $
 
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: DiskStructure.java,v $
 * Revision 1.4  2004/04/05 20:38:33  wrossi
 * Add javadocs
 *
 * Revision 1.3  2003/10/31 12:51:02  wrossi
 * Moved endian into one central location
 *
 * Revision 1.2  2003/10/30 00:49:01  wrossi
 * Added throws clause
 *
 * Revision 1.1  2003/10/29 00:31:38  wrossi
 * Work in progress
 *
 *
 */

package rossi.fstools.fs;

/** Interface for classes that represent data sturctures on disk. */
public interface DiskStructure
{
  /**
   * Get the size in bytes of the structure.  For variable length sturctures
   * this may represent the minimum length rather than the actual length.
   *
   * @return the size of the structure.
   */
  public int getDataSize();

  /**
   * Loads the object from a memory buffer
   *
   * @param buffer   a byte[] containing data to be read in populating the object
   * @param offset   a int indicating the offset within the buffer to start parsing.
   * @exception FsException  if a parse error occurs.
   */
  public void loadFromBuffer(byte[] buffer, int offset) throws FsException;
}
