/*
 * $Id: File.java,v 1.4 2004/04/05 20:38:33 wrossi Exp $
 
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: File.java,v $
 * Revision 1.4  2004/04/05 20:38:33  wrossi
 * Add javadocs
 *
 * Revision 1.3  2004/01/23 21:16:02  wrossi
 * Expose BlockPointerInputStream to user
 *
 * Revision 1.2  2004/01/23 21:13:48  wrossi
 * Added getSlack()
 *
 * Revision 1.1  2003/11/18 11:01:39  wrossi
 * Added generic fs interface
 *
 *
 */

package rossi.fstools.fs;

import rossi.fstools.io.BlockPointerInputStream;

/** An ordinary file. */
public interface File extends FsObject
{
  /**
   * Get a BlockPointerInputStream to the data contained within the file.
   *
   * @see BlockPointerInputStream
   * @return BlockPointerInputStream - an input stream of the file's data.
   */
  public BlockPointerInputStream getData();

  /**
   * Get a BlockPointerInputStream to the slack space contained at the end of the file.
   *
   * @see BlockPointerInputStream
   * @return BlockPointerInputStream - an input stream of the file's slack data.
   */
  public BlockPointerInputStream getSlack();
}
