/*
 * $Id: Ext2FastSymLink.java,v 1.2 2004/04/09 21:11:25 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: Ext2FastSymLink.java,v $
 * Revision 1.2  2004/04/09 21:11:25  wrossi
 * Adding javadocs
 *
 * Revision 1.1  2004/04/03 19:44:27  wrossi
 * Added devices and symlinks
 *
 * Revision 1.2  2003/12/17 22:04:12  wrossi
 * Handle null padding on symlinks
 *
 * Revision 1.1  2003/12/02 21:37:52  wrossi
 * started adding symlinks
 *
 * Revision 1.1  2003/11/26 21:39:24  wrossi
 * Working on file extraction
 *
 *
 */

package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.ext2fs.Ext2Inode;

import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.FsException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Fast implementation of SymLink.
 * On EXT2, symlinks less than 60 bytes long may be stored in the Inode, reusing the
 * block pointers.  This class handles that case.
 */

public class Ext2FastSymLink implements SymLink
{
  private String linkTarget;

  /**
   * Create a Symlink from an Inode.
   * @param inode   a Ext2Inode
   * @exception IOException
   */
  public Ext2FastSymLink(Ext2Inode inode) throws IOException
  {
    linkTarget = new String(inode.getBlockData(), 0, (int)inode.getSize(), "ISO-8859-1");
  }

  public String getLink()
  {
    return linkTarget;
  }
}
