/*
 * $Id: Ext2InodePtr.java,v 1.3 2004/04/09 21:41:05 wrossi Exp $
 *
 * (C) Copyright 2004 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: Ext2InodePtr.java,v $
 * Revision 1.3  2004/04/09 21:41:05  wrossi
 * Added javadocs.
 *
 * Revision 1.2  2004/03/31 21:45:33  wrossi
 * Starting file system
 *
 * Revision 1.1  2004/03/31 12:33:08  wrossi
 * Added comments and inode pointer class
 *
 *
 */

package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.InodePtr; 

/** 
 *  Pointer to an Inode on ext2.  This is merely a wrapper around the 32 bit 
 *  inode number.
 */
public class Ext2InodePtr implements InodePtr
{
  private long inodeNumber;

  public Ext2InodePtr(long inum)
  {
    inodeNumber = inum;
  }

  public long getNumber()
  {
    return inodeNumber;
  }

  public boolean equals(Object obj)
  {
    long inum;

    if (obj instanceof Ext2InodePtr == false)
      return false;

    inum = ((Ext2InodePtr) obj).getNumber();
    return (inum == getNumber());
  }
}
