/*
 * $Id: ReiserDevice.java,v 1.2 2004/04/08 23:45:12 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: ReiserDevice.java,v $
 * Revision 1.2  2004/04/08 23:45:12  wrossi
 * Working on javadoc
 *
 * Revision 1.1  2003/12/08 21:32:48  wrossi
 * Added device support
 *
 *
 */

package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.Device;
import rossi.fstools.fs.Inode;

/**
 * Representation of a unix device.
 */
public class ReiserDevice implements Device
{
  private boolean blockDev = false;
  private boolean charDev = false;
  private int major;
  private int minor;

  /**
   * Crate the device from the inode (stat data)
   * @param inode   a StatDataItem
   */
  public ReiserDevice(StatDataItem inode)
  {
    if ( (inode.getMode() & Inode.FILETYPE_MASK) == Inode.CHARDEV_MODE )
      charDev = true;

    if ( (inode.getMode() & Inode.FILETYPE_MASK) == Inode.BLOCKDEV_MODE )
      blockDev = true;

    major = (inode.getRDev() & 0xff00) >> 8;
    minor = (inode.getRDev() & 0xff);
  }

  public boolean isBlockDev()
  {
    return blockDev;
  }

  public boolean isCharDev()
  {
    return charDev;
  }

  public int getMajor()
  {
    return major;
  }

  public int getMinor()
  {
    return minor;
  }
}
