/*
 * $Id: ReiserDirectory.java,v 1.3 2004/04/08 23:45:12 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: ReiserDirectory.java,v $
 * Revision 1.3  2004/04/08 23:45:12  wrossi
 * Working on javadoc
 *
 * Revision 1.2  2003/11/19 21:12:30  wrossi
 * Reading directories works
 *
 * Revision 1.1  2003/11/18 21:40:25  wrossi
 * Adding dir read support
 *
 *
 */

package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.Directory;
import rossi.fstools.fs.InodePtr;
import java.util.HashMap;
import java.util.Map;

/**
 * Representation of a directory.
 */

public class ReiserDirectory implements Directory
{
  private Map dirMap;

  /**
   * Create a new directory.
   */
  public ReiserDirectory()
  {
    dirMap = new HashMap();
  }

  /**
   * Add a directory item to this directory.  The item will be parsed into DirEntry objects, 
   * echo of which will be added to the map.
   */
  public void add(DirectoryItem dirItem)
  {
    DirEntry entries[];
    Key key;

    entries = dirItem.getEntries();
    for (int i=0; i<entries.length; i++)
    {
      key = new KeyV2();
      key.setParentDirId(entries[i].getParentDirId());
      key.setObjectId(entries[i].getObjectId());
      key.setOffset(0);
      key.setType(Key.TYPE_STAT_DATA);

      dirMap.put(entries[i].getName(), key);
    }
  }

  public Map getInodePtrMap()
  {
    return dirMap;
  }
}
