/*
 * $Id: ReiserSymLink.java,v 1.3 2004/04/08 23:45:12 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: ReiserSymLink.java,v $
 * Revision 1.3  2004/04/08 23:45:12  wrossi
 * Working on javadoc
 *
 * Revision 1.2  2003/12/17 22:04:12  wrossi
 * Handle null padding on symlinks
 *
 * Revision 1.1  2003/12/02 21:37:52  wrossi
 * started adding symlinks
 *
 * Revision 1.1  2003/11/26 21:39:24  wrossi
 * Working on file extraction
 *
 *
 */

package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.File;
import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.FsException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * Representation of a symlink.  SymLink data is stored as if it were a File in ReiserFS.
 */

public class ReiserSymLink implements SymLink
{
  private String linkTarget;

  /**
   * Create the SymLink given a File.
   *
   * @param f   a ReiserFile
   * @exception IOException
   * @exception FsException
   */
  public ReiserSymLink(ReiserFile f) throws IOException, FsException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();

    copyFile(f.getData(), bout);   

    try
    {
      linkTarget = new String(bout.toByteArray(), "ISO-8859-1");

      /* May be zero padded */
      int zeroidx = linkTarget.indexOf('\u0000');
      if (zeroidx > 0)
        linkTarget = linkTarget.substring(0, zeroidx);
    }
    catch (Exception ex)
    {
      FsException fex = new FsException(ex.getMessage());
      fex.initCause(ex);
      throw fex;
    }
  }

  public String getLink()
  {
    return linkTarget;
  }

  private void copyFile(InputStream in, OutputStream out) throws IOException
  {
    int bytesRead;
    byte[] buffer;
    buffer = new byte[8192];

    while (true)
    {
      bytesRead = in.read(buffer, 0, buffer.length);
      if (bytesRead == -1)
        break;
      out.write(buffer, 0, bytesRead);
      out.flush();
    }

    in.close();
    out.close();
  }
}
