/*
 * $Id: StatDataItem.java,v 1.5 2004/04/08 23:45:12 wrossi Exp $
 
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: StatDataItem.java,v $
 * Revision 1.5  2004/04/08 23:45:12  wrossi
 * Working on javadoc
 *
 * Revision 1.4  2003/11/18 11:01:39  wrossi
 * Added generic fs interface
 *
 * Revision 1.3  2003/11/13 21:18:28  wrossi
 * Added toString()
 *
 * Revision 1.2  2003/11/12 21:29:31  wrossi
 * Working on stat data items.
 *
 * Revision 1.1  2003/11/12 21:14:31  wrossi
 * Created stat data item
 *
 * Revision 1.4  2003/11/12 11:05:49  wrossi
 * Added getRDev function
 *
 * Revision 1.3  2003/11/11 21:30:22  wrossi
 * Working on stat data
 *
 * Revision 1.2  2003/11/11 11:14:54  wrossi
 * Filled in setters/getters
 *
 * Revision 1.1  2003/11/11 00:56:06  wrossi
 * Adding stat data
 *
 *
 */

package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.Inode;

/**
 * StatDataItem holds statistics about the object it describes.  It is a close
 * analogy to the Inodes in other filesystems except it doesnt directly hold block
 * pointers. 
 */
public abstract class StatDataItem extends Item implements Inode
{
  public StatDataItem(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException
  { 
    super(buffer, bufferOffset, block, header);
  }

  public abstract int getMode();
  public abstract void setMode(int aMode);

  public abstract long getNumLinks();
  public abstract void setNumLinks(long aNumLinks);

  public abstract long getUserId();
  public abstract void setUserId(long aUserId);

  public abstract long getGroupId();
  public abstract void setGroupId(long aGroupId);

  public abstract long getSize();
  public abstract void setSize(long aSize);

  public abstract long getAccessTime();
  public abstract void setAccessTime(long aAccessTime);

  public abstract long getModifyTime();
  public abstract void setModifyTime(long aModifyTime);

  public abstract long getChangedTime();
  public abstract void setChangedTime(long aChangedTime);

  public abstract long getBlocks();
  public abstract void setBlocks(long aBlocks);

  //public abstract long getFirstDirect();
  //public abstract void setFirstDirect(long aFirstDirect);

  /** Get the device major/minor numbers. */
  public abstract int getRDev();

  /**
   * Create the appropriate subclass for a StatDataItem on disk.   Figure out
   * if its V1 or V2 based on the item size.
   *
   * @param buffer   a byte[] buffer holding the item
   * @param bufferOffset   a int offset into the buffer marking the start of the item
   * @param block   the LeafNode containing this item
   * @param header   the ItemHead for this item
   * @return StatDataItem 
   * @exception FsException
   */
  public static StatDataItem create (byte[] buffer, int bufferOffset, 
                                LeafNode block, ItemHead header) throws FsException
  {
    int itemSize = header.getItemLen();

    if (itemSize == StatDataV1.getDataSize())
      return new StatDataV1(buffer, bufferOffset, block, header);

    if (itemSize == StatDataV2.getDataSize()) // size of V1
      return new StatDataV2(buffer, bufferOffset, block, header);

    throw new FsException("Invalid size for Stat item "+itemSize);
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer();

    sb.append("[Mode=0x"+Integer.toHexString(getMode()));
    sb.append(",numlinks="+getNumLinks());
    sb.append(",userid="+getUserId());
    sb.append(",groupid="+getGroupId());
    sb.append(",size="+getSize());
    sb.append(",atime="+getAccessTime());
    sb.append(",mtime="+getModifyTime());
    sb.append(",ctime="+getChangedTime());
    sb.append(",blocks="+getBlocks());
    sb.append("]");

    return sb.toString();
  }
}
