/*
 * $Id: BlockPointer.java,v 1.3 2004/03/11 00:39:56 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: BlockPointer.java,v $
 * Revision 1.3  2004/03/11 00:39:56  wrossi
 * Performance boost.  Allow a single BlockPointer to point to multiple
 * contigous blocks.  This reduces our memory footprint considerably
 *
 * Revision 1.2  2003/11/30 15:48:38  wrossi
 * bug fixes
 *
 * Revision 1.1  2003/11/25 21:37:36  wrossi
 * IO for reading files
 *
 *
 */

package rossi.fstools.io;

/** This class represents a pointer to a chunk of data on disk.  A file may
    be composed of a list of these. 

    Note that length may be longer than blockSize.  In which case this pointer
    represents multiple consecutive blocks.
 */
public class BlockPointer
{
  protected int blockNum;
  protected int offset;
  protected int length;
  protected int blockSize;

  public int getBlockNum() { return blockNum; }
  public void setBlockNum(int aBlockNum) { blockNum=aBlockNum; }

  public int getOffset() { return offset; }
  public void setOffset(int aOffset) { offset=aOffset; }

  public int getLength() { return length; }
  public void setLength(int aLength) { length=aLength; }

  public int getBlockSize() { return blockSize; }
  public void setBlockSize(int aBlockSize) { blockSize=aBlockSize; }

  public String toString()
  {
    return "bp("+blockNum+", "+offset+", "+length+", "+blockSize+")";
  }
}

