/*
 * $Id: PhysicalDisk.java,v 1.3 2004/02/28 21:57:29 wrossi Exp $
 *
 * (C) Copyright 2004 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: PhysicalDisk.java,v $
 * Revision 1.3  2004/02/28 21:57:29  wrossi
 * Dont put logical partition containers into list
 *
 * Revision 1.2  2004/02/28 21:46:09  wrossi
 * Got partition parsing working
 *
 * Revision 1.1  2004/02/28 20:44:43  wrossi
 * Partition support
 *
 *
 */

package rossi.fstools.partition;

import rossi.fstools.io.BlockReader;
import rossi.fstools.fs.FsException;

import java.io.IOException;

import java.util.List;
import java.util.ArrayList;

public class PhysicalDisk
{
  protected BlockReader blockReader;

  public void open(BlockReader blockReader)
  {
    this.blockReader = blockReader;
  }

  public void close() throws IOException
  {
    blockReader.close();
  }
 
  /* This gets called recursively to load logical partitions */
  protected void loadLogicalPartitions(List partitionList, 
                                       PartitionTable logicalContainer, 
                                       long tableOffset, 
                                       Partition extendedPartition) throws IOException, FsException
  {
    Partition parts[];   

    parts = logicalContainer.getPartitions();
    for (int i=0; i<parts.length; i++)
    {
      if (parts[i].getNumLBASector() == 0) 
        continue;

      /* If its an extended partition, find the new partition table at offset 
         extendedPartition.getStartLBA() + parts[i].getStartLBA() */

      if (parts[i].isExtended())
      {
        PartitionTable nextLogicalContainer = new PartitionTable();
        long nextTableOffset = extendedPartition.getStartLBA() + parts[i].getStartLBA();
        byte[] ptbl = blockReader.getBlock((int) nextTableOffset);
        nextLogicalContainer.loadFromBuffer(ptbl, 0);

        loadLogicalPartitions(partitionList, nextLogicalContainer, nextTableOffset, extendedPartition);
        continue;
      }

      /* At this point, we have a real logical parition, add the container's 
         startLBA to its startLBA */
      parts[i].setStartLBA(parts[i].getStartLBA() + tableOffset);
      partitionList.add(parts[i]);
    }
  }

  public Partition[] getPartitions() throws IOException, FsException
  {
    PartitionTable mbrTable = new PartitionTable();
    ArrayList partitionList = new ArrayList();
    Partition extendedPartition = null;  // only allowed one of these - makes things easier
    byte mbr[];

    blockReader.setBlockSize(512);
    mbr = blockReader.getBlock(0);
    mbrTable.loadFromBuffer(mbr, 0);

    Partition primaryParts[] = mbrTable.getPartitions();
    for (int i=0; i<primaryParts.length; i++)
    {
      if (primaryParts[i].isExtended())
        extendedPartition = primaryParts[i];

      partitionList.add(primaryParts[i]);
    }

    if (extendedPartition != null)
    {
      PartitionTable logicalContainer = new PartitionTable();
      byte[] ptbl = blockReader.getBlock((int) extendedPartition.getStartLBA());
      logicalContainer.loadFromBuffer(ptbl, 0);

      loadLogicalPartitions(partitionList, logicalContainer, 
                            extendedPartition.getStartLBA(), extendedPartition);
    }

    return (Partition[]) partitionList.toArray(new Partition[0]);
  }
}
