
import rossi.fstools.fs.reiserfs.ReiserSuperBlock;
import rossi.fstools.fs.reiserfs.InternalNode;
import rossi.fstools.fs.reiserfs.LeafNode;
import rossi.fstools.fs.reiserfs.FBlock;
import rossi.fstools.fs.reiserfs.Key;
import rossi.fstools.io.BlockIO;

import java.io.RandomAccessFile;

printKey(Key k)
{
  return "{"+k.getParentDirId()+" "+k.getObjectId()+" "+k.getOffset()+" "+k.getType()+"}";
}

RandomAccessFile rafile = new RandomAccessFile("/home/wrossi/exponent/reisertest", "r");
//RandomAccessFile rafile = new RandomAccessFile("/dev/hda2", "r");

BlockIO blkio = new BlockIO(rafile, 4096);

ReiserSuperBlock sb = new ReiserSuperBlock();

buffer = blkio.getBlock(16);  // location of superblock

/* Load the super block */
sb.loadFromBuffer(buffer, 0);


int rootBlock = (int) sb.getRootBlock();
print ("Root Block = "+rootBlock);


buffer = blkio.getBlock(rootBlock);
//inode = new InternalNode(sb, (int) rootBlock);
inode = FBlock.createFromBuffer(sb, (int) rootBlock, buffer, 0);
//inode.loadFromBuffer(buffer, 0);

if (inode instanceof LeafNode)
{
  headers = (inode.getItemHeaders());
  for (int i=0; i<headers.length; i++)
    print (printKey(headers[i].getKey())+" "+headers[i].getFreeEntCt()+" "+headers[i].getItemLen()+" "+headers[i].getItemLocation());
}

if (inode instanceof InternalNode)
{
  print("Internal Node");
  keys = inode.getKeys();
  print(keys.length);

  for (int i=0; i<keys.length; i++)
  {
    print(printKey(keys[i]));
  }
}
