/*
 * $Id: ExtractDialogThread.java,v 1.4 2004/02/27 13:01:32 wrossi Exp $
 *
 * (C) Copyright 2004 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: ExtractDialogThread.java,v $
 * Revision 1.4  2004/02/27 13:01:32  wrossi
 * Hooked up recursive checkbox and cancel button
 *
 * Revision 1.3  2004/02/26 21:38:54  wrossi
 * Improving extraction
 *
 * Revision 1.2  2004/02/25 21:41:32  wrossi
 * Extract working
 *
 * Revision 1.1  2004/02/25 21:18:11  wrossi
 * Thread for extracting files
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;

import javax.swing.SwingUtilities;
import javax.swing.JOptionPane;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.FileOutputStream;

import java.util.Enumeration;

public class ExtractDialogThread extends Thread
{
  protected ExtractDialog exd;
  protected java.io.File targetDir;
  protected FsObject source;
  protected FileSystem fs;
  protected String sourceName;
  protected boolean cancelled = false;
  protected boolean recurse;

  public ExtractDialogThread(ExtractDialog dialog, FileSystem fs, FsObject source, 
                             String sourceName, java.io.File targetDir, boolean recurse)
  {
    exd = dialog;

    this.fs = fs;
    this.source = source;
    this.sourceName = sourceName;
    this.targetDir = targetDir;
    this.recurse = recurse;
  }

  public void cancel()
  {
    cancelled = true;
  }

  public void run()
  {
    try
    {
      java.io.File tDir = targetDir;
      if (source instanceof Directory)
        tDir = new java.io.File(targetDir, sourceName);

      /* Do it */
      extractObject(source, sourceName, tDir, 0);

      closeDialog();
      /*
      if (cancelled)
        message("** Cancelled **");
      else
        message("Done");
      */
    }
    catch (IOException ex)
    {
      JOptionPane.showMessageDialog(exd, 
                 ex.getClass().getName()+": "+ex.getMessage(), "Error",
                 JOptionPane.ERROR_MESSAGE);

      ex.printStackTrace();
    }
  }

  protected void extractObject(FsObject fsobj, String name, java.io.File tDir, int lvl) throws IOException
  {
    if (cancelled || (!recurse && lvl > 1))
      return;

    if (fsobj instanceof Directory)
    {
      Directory dir = (Directory) fsobj;
      FsObjectTreeNode fsn = new FsObjectTreeNode(fs, null, dir, null, name);
      for (Enumeration enum = fsn.children(); enum.hasMoreElements(); )
      {
        FsObjectTreeNode child = (FsObjectTreeNode) enum.nextElement();

        if (child.getName().equals(".") || child.getName().equals(".."))
          continue;

        FsObject childObject = child.getFsObject();
        java.io.File childTarget = tDir;

        if (childObject instanceof Directory)
          childTarget = new java.io.File(tDir, child.getName());

        extractObject(child.getFsObject(), child.getName(), childTarget, lvl+1);
      }
    }

    if (fsobj instanceof rossi.fstools.fs.File)
    {
      java.io.File outputFile = new java.io.File(tDir, name);
      rossi.fstools.fs.File inputFile = (rossi.fstools.fs.File) fsobj;
      tDir.mkdirs();

      OutputStream out = new FileOutputStream(outputFile);
      InputStream in = inputFile.getData();

      message("Writing: "+outputFile.getAbsolutePath());

      copyFile(in, out);
    }
  }

  protected void closeDialog()
  {
    SwingUtilities.invokeLater(new Runnable() 
       {
         public void run()
         {
           exd.setVisible(false);
           exd.dispose();
         }
       });
  }

  protected void message(final String msg)
  {
    SwingUtilities.invokeLater(new Runnable() 
       {
         public void run()
         {
           exd.setStatusText(msg);
         }
       });
  }

  protected void copyFile(InputStream in, OutputStream out) throws IOException
  {
    int bytesRead;
    byte[] buffer;

    buffer = new byte[8192];

    while (true)
    {
      bytesRead = in.read(buffer, 0, buffer.length);
      if (bytesRead == -1)
        break;
      out.write(buffer, 0, bytesRead);
      out.flush();
    }

    in.close();
    out.close();
  }
}
