/*
 * $Id: FsTree.java,v 1.7 2004/01/19 23:22:11 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: FsTree.java,v $
 * Revision 1.7  2004/01/19 23:22:11  wrossi
 * fixed status bar, added renderer for devices.
 *
 * Revision 1.6  2003/12/31 12:22:29  wrossi
 * Hookup tree selection listeners
 *
 * Revision 1.5  2003/12/30 21:33:43  wrossi
 * Connected tree with table in FsViewPanel.
 *
 * Revision 1.4  2003/12/23 21:36:18  wrossi
 * Added colored tree rendering based on file mode (eg dir vs pipe vs device).
 *
 * Revision 1.3  2003/12/17 22:13:57  wrossi
 * Added support for non-directory items.  Display targets of symlinks
 *
 * Revision 1.2  2003/12/17 14:23:22  wrossi
 * Working demo
 *
 * Revision 1.1  2003/12/17 13:54:21  wrossi
 * Tree view of a file system
 *
 * Revision 1.2  2003/12/12 13:31:04  wrossi
 * Wip
 *
 * Revision 1.1  2003/12/12 13:25:07  wrossi
 * TreeNode represening a file system
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;

import java.awt.BorderLayout;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;


public class FsTree extends JPanel
{
  protected JTree tree;
  protected FileSystem fs;

  public FsTree()
  {
    initialize();
    performLayout();
  }

  public void addTreeSelectionListener(TreeSelectionListener l)
  {
    tree.addTreeSelectionListener(l);
  }

  public void setFileSystem(FileSystem fs) throws Exception
  {
    InodePtr rootDirPtr;
    Inode rootDirInode;
    Directory rootDir;
    FsObjectTreeNode rootNode;

    this.fs = fs;

    rootDirPtr = fs.getRootDir();
    rootDirInode = fs.getInode(rootDirPtr);
    rootDir = (Directory) fs.getObject(rootDirInode);

    rootNode = new FsObjectTreeNode(fs, null, rootDir, rootDirInode, "/");
   
    tree.setModel(new DefaultTreeModel(rootNode));
    tree.setCellRenderer(new FsTreeRenderer());
  }

  protected void initialize()
  {
    tree = new JTree();

    // initialize with an empty model
    tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
  }

  protected void performLayout()
  {
    setLayout(new BorderLayout());
    add(tree, "Center");
  }

}
