/*
 * $Id: FsViewFrame.java,v 1.10 2004/03/04 21:35:00 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: FsViewFrame.java,v $
 * Revision 1.10  2004/03/04 21:35:00  wrossi
 * Working partition dialog
 *
 * Revision 1.9  2004/03/01 12:02:46  wrossi
 * Added menu items and actions
 *
 * Revision 1.8  2004/02/25 12:03:22  wrossi
 * Working on extraction
 *
 * Revision 1.7  2004/02/24 21:41:05  wrossi
 * Working on extraction
 *
 * Revision 1.6  2004/02/22 20:49:13  wrossi
 * Added argument for an offset
 *
 * Revision 1.5  2004/02/18 21:35:06  wrossi
 * Working on menu actions
 *
 * Revision 1.4  2004/02/17 21:40:26  wrossi
 * Working on extract file menu and supporting APIs
 *
 * Revision 1.3  2004/02/11 21:39:42  wrossi
 * added menubar
 *
 * Revision 1.2  2004/02/11 21:34:04  wrossi
 * Adding menu bar and actions
 *
 * Revision 1.1  2004/02/10 21:40:54  wrossi
 * Frame for file system viewer
 *
 *
 */

package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.io.RandomAccessFile;

import java.util.Map;
import java.util.HashMap;

import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;

import rossi.fstools.io.BlockIO;
import rossi.fstools.fs.reiserfs.ReiserFileSystem;

import rossi.fstoolsui.actions.ExtractFileAction;
import rossi.fstoolsui.actions.OpenPartitionAction;
import rossi.fstoolsui.actions.ExitAction;

/** Main frame for the File System viewer */
public class FsViewFrame extends JFrame 
{
  protected FsViewPanel fsview;
  protected JMenuBar menuBar;
  protected HashMap actionMap;

  public FsViewFrame()
  {
    initialize();
  }

  public FsViewPanel getFsViewPanel()
  {
    return fsview;
  }

  protected void initialize()
  {
    FileSystem fs;
    RandomAccessFile rafile;
    BlockIO blkio;

    fsview = new FsViewPanel();
    fsview.addListSelectionListener(new ListSelectionListener() 
       {
         public void valueChanged(ListSelectionEvent evt)
         {
           Action extractAction = (Action) actionMap.get("extractFile");
           FsObject fsobj = fsview.getCurrentFsObject();
           extractAction.setEnabled( fsobj != null && (fsobj instanceof File || fsobj instanceof Directory));
         }
       });
    menuBar = new JMenuBar();

    setupActions();
    setupMenuBar();

    setJMenuBar(menuBar);

    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(fsview, "Center");

    addWindowListener(new WindowAdapter()
      {
        public void windowClosing(WindowEvent evt)
        {
          Action action = (Action) actionMap.get("exit");
          action.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "Exit"));
        }
      });

    setSize(600, 500);
    show();
  }

  protected void setupActions()
  {
    Action a;

    actionMap = new HashMap();

    a = new ExtractFileAction();
    a.setEnabled(false);
    a.putValue("frame", this);
    actionMap.put("extractFile", a);

    a = new OpenPartitionAction();
    a.putValue("frame", this);
    actionMap.put("openPartition", a);

    a = new ExitAction();
    a.putValue("frame", this);
    actionMap.put("exit", a);
  }

  protected void setupMenuBar()
  {
    JMenu m;

    m = new JMenu("File");
    m.add( (Action) actionMap.get("extractFile"));
    m.add( (Action) actionMap.get("openPartition"));
    m.add( (Action) actionMap.get("exit"));
 
    menuBar.add(m);
  }

  public void setFileSystem(FileSystem fs) throws Exception
  {
    fsview.setFileSystem(fs);
  }

  public FileSystem getFileSystem()
  {
    return fsview.getFileSystem();
  }

  public static void main(String args[]) throws Exception
  {
    FileSystem fs;
    RandomAccessFile rafile;
    BlockIO blkio;
    FsViewFrame frame = new FsViewFrame();
    long offset = 0;

    if (args.length == 0)
      return;

    if (args.length > 1)
      offset = Long.parseLong(args[1]);

    rafile = new RandomAccessFile(args[0], "r");
    blkio = new BlockIO(rafile, 4096, offset);

    fs = new ReiserFileSystem();
    fs.open(blkio);

    frame.setFileSystem(fs);
  }
}
