/*
 * $Id: PartitionTablePanel.java,v 1.6 2004/03/05 21:37:35 wrossi Exp $
 *
 * (C) Copyright 2003 Rossi Engineering, Inc.  All Rights Reserved
 *
 * $Log: PartitionTablePanel.java,v $
 * Revision 1.6  2004/03/05 21:37:35  wrossi
 * Added partition types to partition dialog
 *
 * Revision 1.5  2004/03/05 12:44:15  wrossi
 * Added double click handler on partition table panel
 *
 * Revision 1.4  2004/03/04 21:35:00  wrossi
 * Working partition dialog
 *
 * Revision 1.3  2004/03/03 21:30:14  wrossi
 * Working on partition dialog
 *
 * Revision 1.2  2004/03/03 21:12:55  wrossi
 * Working on open partition dialog
 *
 * Revision 1.1  2004/03/02 21:34:43  wrossi
 * Panel to hold the Partition table
 *
 * Revision 1.1  2004/03/02 21:17:46  wrossi
 *
 */

package rossi.fstoolsui.fstree;

import rossi.fstools.partition.PhysicalDisk;
import rossi.fstools.partition.Partition;
import rossi.fstools.io.BlockIO;

import javax.swing.table.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import javax.swing.*;

import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Component;
import java.awt.Color;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;

import java.io.RandomAccessFile;
import java.io.IOException;

public class PartitionTablePanel extends JPanel implements MouseListener
{
  /** The table itself */
  protected JTable tbl;
  /** The table model */
  protected TableModel model;
  /** The disk device name */
  protected String diskName;
  /** Action listeners */
  protected List actionListeners = new ArrayList();

  public PartitionTablePanel()
  {
    initialize();
  }

  protected void initialize()
  {
    model = getModel(null);
    TableColumnModel cm = getColumnModel(model);

    tbl = new JTable(model, cm);
    tbl.setSurrendersFocusOnKeystroke(true);

    tbl.setAutoResizeMode(tbl.AUTO_RESIZE_OFF);

    tbl.addMouseListener(this);
    tbl.getTableHeader().addMouseListener(this);

    setLayout(new BorderLayout());

    JScrollPane sp = new JScrollPane(tbl);

    add(sp, "Center");
  }

  public void setDisk(String diskName)
  {
    this.diskName = diskName;
    model = getModel(diskName);
    tbl.setModel(model);
  }
  
  protected TableModel getModel(String dName)
  {
    RandomAccessFile rafile = null;

    if (dName == null)
      return new PartitionTableModel(new ArrayList());

    try
    {
      rafile = new RandomAccessFile(dName, "r");
      BlockIO blkio = new BlockIO(rafile, 512);
      PhysicalDisk disk = new PhysicalDisk();
      disk.open(blkio);

      Partition parts[] = disk.getPartitions();

      return new PartitionTableModel(Arrays.asList(parts));
    }
    catch (Exception ex)
    {
      JOptionPane.showMessageDialog(this, 
                 ex.getClass().getName()+": "+ex.getMessage(), "Error",
                 JOptionPane.ERROR_MESSAGE);
      ex.printStackTrace();
    }
    finally
    {
      try
      {
        if (rafile != null)
          rafile.close();
      }
      catch (Exception ex)
      {
      }
    }
    return new PartitionTableModel(new ArrayList());
  }

  protected TableColumnModel getColumnModel(TableModel model)
  {
    DefaultTableColumnModel cm = new DefaultTableColumnModel();
    DefaultTableCellRenderer def = new DefaultTableCellRenderer();
    int width[] = {45, 170, 60};

    for (int i=0; i<model.getColumnCount(); i++)
    {
      TableColumn c = new TableColumn(i, width[i]);
      c.setHeaderValue(model.getColumnName(i));
      cm.addColumn(c);
    }

    return cm;
  }

  public Partition getSelectedPartition()
  {
    int row = tbl.getSelectedRow();

    if (row == -1)
      return null;

    return ((PartitionTableModel)model).getPartitionForRow(row);
  }

  public int getSelectedPartitionOrdinal()
  {
    int row = tbl.getSelectedRow();

    if (row == -1)
      return 0;

    return ((PartitionTableModel)model).getPartitionOrdinalForRow(row);
  }

  /** MouseListener interface */
  public void mousePressed(MouseEvent evt)
  {
  }

  /** MouseListener interface */
  public void mouseReleased(MouseEvent evt)
  {
  }

  /** MouseListener interface */
  public void mouseEntered(MouseEvent evt)
  {
  }

  /** MouseListener interface */
  public void mouseExited(MouseEvent evt)
  {
  }

  /** MouseListener interface */
  public void mouseClicked(MouseEvent evt)
  {
    if (SwingUtilities.isLeftMouseButton(evt))
    {
      if (evt.getClickCount() == 2)
      {
        handleDoubleClick();
      }
    }
  }

  protected void fireActionEvent()
  {
    ActionEvent evt = new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "cmd" );
    synchronized(actionListeners)
    {
      for (Iterator itr=actionListeners.iterator(); itr.hasNext(); )
      {
        ActionListener al = (ActionListener) itr.next();
        al.actionPerformed(evt);
      }
    }
  }

  public void addActionListener(ActionListener al)
  {
    synchronized (actionListeners)
    {
      actionListeners.add(al);
    }
  }

  protected void handleDoubleClick()
  {
    fireActionEvent();
  }

  /** Get the table so our panent component can add listeners to it */
  public JTable getTable()
  {
    return tbl;
  }


}
