/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstoolsui.fstree.ExtractDialogThread;

public class ExtractDialog
extends JDialog {
    protected JTextField targetDirTF;
    protected JTextField sourceTF;
    protected JButton fileChooseBTN;
    protected JButton okBTN;
    protected JButton cancelBTN;
    protected JLabel statusLabel;
    protected JCheckBox recurseCB;
    protected FsObject sourceFsObj;
    protected FileSystem fs;
    protected String sourceName;
    protected ExtractDialogThread extractThread;

    public ExtractDialog(JFrame parent, FileSystem fs, FsObject sourceFsObj, String sourceName) {
        super((Frame)parent, "Extract File");
        this.sourceFsObj = sourceFsObj;
        this.sourceName = sourceName;
        this.fs = fs;
        this.initialize();
        this.performLayout();
    }

    protected void initialize() {
        this.targetDirTF = new JTextField(20);
        this.targetDirTF.setText(System.getProperty("user.home"));
        this.sourceTF = new JTextField(20);
        this.sourceTF.setEditable(false);
        this.sourceTF.setText(this.sourceName);
        this.fileChooseBTN = new JButton("...");
        this.fileChooseBTN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(new File(ExtractDialog.this.targetDirTF.getText()));
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(ExtractDialog.this);
                if (returnVal == 0) {
                    ExtractDialog.this.targetDirTF.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(new BevelBorder(1));
        this.recurseCB = new JCheckBox("Recursive");
        this.recurseCB.setEnabled(this.sourceFsObj instanceof Directory);
        this.okBTN = new JButton("Ok");
        this.okBTN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractDialog.this.extractThread = new ExtractDialogThread(ExtractDialog.this, ExtractDialog.this.fs, ExtractDialog.this.sourceFsObj, ExtractDialog.this.sourceName, new File(ExtractDialog.this.targetDirTF.getText()), ExtractDialog.this.recurseCB.isSelected());
                ExtractDialog.this.extractThread.start();
            }
        });
        this.cancelBTN = new JButton("Cancel");
        this.cancelBTN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ExtractDialog.this.extractThread != null) {
                    ExtractDialog.this.extractThread.cancel();
                }
                ExtractDialog.this.setVisible(false);
                ExtractDialog.this.dispose();
            }
        });
    }

    protected void performLayout() {
        Container pane = this.getContentPane();
        GridBagLayout gridb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridb);
        JPanel buttonPanel = new JPanel();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JComponent comp = new JLabel("Extract file(s) from:");
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        comp = this.sourceTF;
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        comp = new JLabel("Extract file(s) to:");
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        comp = this.targetDirTF;
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        comp = this.fileChooseBTN;
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        comp = this.recurseCB;
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 2.0;
        c.weighty = 2.0;
        comp = buttonPanel;
        gridb.setConstraints(comp, c);
        mainPanel.add(comp);
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)this.okBTN, (Object)this.cancelBTN);
        buttonPanel.add((Component)this.cancelBTN, (Object)this.cancelBTN);
        pane.setLayout(new BorderLayout());
        pane.add((Component)mainPanel, "Center");
        pane.add((Component)this.statusLabel, "South");
    }

    public void setStatusText(String text) {
        this.statusLabel.setText(text);
    }
}

