/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstools.io.BlockPointerInputStream;
import rossi.fstoolsui.fstree.ExtractDialog;
import rossi.fstoolsui.fstree.FsObjectTreeNode;

public class ExtractDialogThread
extends Thread {
    protected ExtractDialog exd;
    protected File targetDir;
    protected FsObject source;
    protected FileSystem fs;
    protected String sourceName;
    protected boolean cancelled = false;
    protected boolean recurse;

    public ExtractDialogThread(ExtractDialog dialog, FileSystem fs, FsObject source, String sourceName, File targetDir, boolean recurse) {
        this.exd = dialog;
        this.fs = fs;
        this.source = source;
        this.sourceName = sourceName;
        this.targetDir = targetDir;
        this.recurse = recurse;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run() {
        try {
            File tDir = this.targetDir;
            if (this.source instanceof Directory) {
                tDir = new File(this.targetDir, this.sourceName);
            }
            this.extractObject(this.source, this.sourceName, tDir, 0);
            this.closeDialog();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.exd, ex.getClass().getName() + ": " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
    }

    protected void extractObject(FsObject fsobj, String name, File tDir, int lvl) throws IOException {
        if (this.cancelled || !this.recurse && lvl > 1) {
            return;
        }
        if (fsobj instanceof Directory) {
            Directory dir = (Directory)fsobj;
            FsObjectTreeNode fsn = new FsObjectTreeNode(this.fs, null, dir, null, name);
            Enumeration enumeration = fsn.children();
            while (enumeration.hasMoreElements()) {
                FsObjectTreeNode child = (FsObjectTreeNode)enumeration.nextElement();
                if (child.getName().equals(".") || child.getName().equals("..")) continue;
                FsObject childObject = child.getFsObject();
                File childTarget = tDir;
                if (childObject instanceof Directory) {
                    childTarget = new File(tDir, child.getName());
                }
                this.extractObject(child.getFsObject(), child.getName(), childTarget, lvl + 1);
            }
        }
        if (fsobj instanceof rossi.fstools.fs.File) {
            File outputFile = new File(tDir, name);
            rossi.fstools.fs.File inputFile = (rossi.fstools.fs.File)fsobj;
            tDir.mkdirs();
            FileOutputStream out = new FileOutputStream(outputFile);
            BlockPointerInputStream in = inputFile.getData();
            this.message("Writing: " + outputFile.getAbsolutePath());
            this.copyFile(in, out);
        }
    }

    protected void closeDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtractDialogThread.this.exd.setVisible(false);
                ExtractDialogThread.this.exd.dispose();
            }
        });
    }

    protected void message(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtractDialogThread.this.exd.setStatusText(msg);
            }
        });
    }

    protected void copyFile(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, bytesRead);
            out.flush();
        }
        in.close();
        out.close();
    }
}

