/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import rossi.fstools.fs.File;
import rossi.fstools.io.BlockPointer;

public class FileViewPanel
extends JPanel {
    protected JLabel typeLabel;
    protected JLabel hexLabel;
    protected JLabel textLabel;
    protected JLabel blockLabel;
    protected JLabel slackLabel;
    protected JTabbedPane tabPane;
    private static final int MAX_BUFFER = 8192;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FileViewPanel() {
        this.initialize();
        this.performLayout();
    }

    protected void initialize() {
        this.tabPane = new JTabbedPane();
        this.typeLabel = new JLabel();
        this.typeLabel.setVerticalAlignment(1);
        this.hexLabel = new JLabel();
        this.hexLabel.setVerticalAlignment(1);
        this.textLabel = new JLabel();
        this.textLabel.setVerticalAlignment(1);
        this.blockLabel = new JLabel();
        this.blockLabel.setVerticalAlignment(1);
        this.slackLabel = new JLabel();
        this.slackLabel.setVerticalAlignment(1);
    }

    protected void performLayout() {
        this.setLayout(new BorderLayout());
        this.tabPane.add((Component)new JScrollPane(this.hexLabel), "Hex");
        this.tabPane.add((Component)new JScrollPane(this.textLabel), "Text");
        this.tabPane.add((Component)new JScrollPane(this.blockLabel), "Blocks");
        this.tabPane.add((Component)new JScrollPane(this.slackLabel), "Slack");
        this.add((Component)this.tabPane, "Center");
    }

    public void setFile(File f) {
        try {
            byte[] buffer = this.getBuffer(f.getData());
            byte[] slack = this.getBuffer(f.getSlack());
            this.hexLabel.setText("<html><pre>" + this.hexString(buffer) + "</pre>");
            this.textLabel.setText(this.bytesToText(buffer));
            this.blockLabel.setText(this.getBlocksText(f));
            this.slackLabel.setText("<html><pre>" + this.hexString(slack) + "</pre>");
        }
        catch (Exception ex) {
            this.hexLabel.setText(ex.getClass().getName() + ": " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected byte[] getBuffer(InputStream in) throws IOException {
        int br;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        for (int count = 0; count < 8192 && (br = in.read(buffer)) != -1; count += br) {
            bout.write(buffer, 0, br);
        }
        bout.close();
        return bout.toByteArray();
    }

    protected String getBlocksText(File f) {
        StringBuffer sb = new StringBuffer(262144);
        sb.append("<html><table><tr><td>Block no.</td><td>Offset</td><td>Size</td></tr>");
        Iterator itr = f.getData().getBlocks();
        while (itr.hasNext()) {
            BlockPointer bp = (BlockPointer)itr.next();
            sb.append("<tr><td>");
            sb.append(Long.toString(bp.getBlockNum()));
            sb.append("</td><td>");
            sb.append(Integer.toString(bp.getOffset()));
            sb.append("</td><td>");
            sb.append(Integer.toString(bp.getLength()));
            sb.append("</td></tr>");
        }
        sb.append("</table></html>");
        return sb.toString();
    }

    protected String hexString(byte[] buffer) {
        StringBuffer sb = new StringBuffer(262144);
        for (int i = 0; i <= buffer.length; i += 16) {
            this.formatHexLine(buffer, i, sb);
        }
        if (buffer.length == 8192) {
            sb.append("\n\n**End of buffer, to see more extract the file**");
        }
        return sb.toString();
    }

    protected String bytesToText(byte[] buffer) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><pre>");
        for (int i = 0; i < buffer.length; ++i) {
            this.formatByte(buffer[i], sb, true);
        }
        sb.append("</pre>");
        if (buffer.length == 8192) {
            sb.append("\n\n**End of buffer, to see more extract the file**");
        }
        return sb.toString();
    }

    protected void formatByte(byte b, StringBuffer sb, boolean allowNewline) {
        if (b > 31 && b < 127) {
            switch ((char)b) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append((char)b);
                    break;
                }
            }
        } else if (allowNewline && (b == 10 || b == 13)) {
            sb.append((char)b);
        } else {
            sb.append(".");
        }
    }

    protected void intToHexString(StringBuffer sb, int hexNumber, int numDigits) {
        char[] buffer = new char[numDigits];
        int x = hexNumber;
        for (int i = buffer.length - 1; i >= 0; --i) {
            buffer[i] = hexDigits[x & 0xF];
            x >>= 4;
        }
        sb.append(buffer);
    }

    protected void formatHexLine(byte[] buffer, int offset, StringBuffer sb) {
        this.intToHexString(sb, offset, 4);
        sb.append(" ");
        for (int x = 0; x < 2; ++x) {
            for (int i = 0; i < 8; ++i) {
                sb.append(" ");
                if (i + offset + x * 8 < buffer.length) {
                    int b = buffer[i + offset + x * 8] & 0xFF;
                    this.intToHexString(sb, b, 2);
                    continue;
                }
                sb.append("  ");
            }
        }
        sb.append("  ");
        for (int i = 0; i < 16; ++i) {
            if (i + offset >= buffer.length) {
                sb.append(" ");
                continue;
            }
            byte b = buffer[i + offset];
            this.formatByte(b, sb, false);
        }
        sb.append("\n");
    }
}

