/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;
import rossi.fstoolsui.fstree.FsObjectTreeNode;
import rossi.fstoolsui.fstree.FsTreeRenderer;

public class FsTree
extends JPanel {
    protected JTree tree;
    protected FileSystem fs;

    public FsTree() {
        this.initialize();
        this.performLayout();
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.tree.addTreeSelectionListener(l);
    }

    public void setFileSystem(FileSystem fs) throws Exception {
        this.fs = fs;
        InodePtr rootDirPtr = fs.getRootDir();
        Inode rootDirInode = fs.getInode(rootDirPtr);
        Directory rootDir = (Directory)fs.getObject(rootDirInode);
        FsObjectTreeNode rootNode = new FsObjectTreeNode(fs, null, rootDir, rootDirInode, "/");
        this.tree.setModel(new DefaultTreeModel(rootNode));
        this.tree.setCellRenderer(new FsTreeRenderer());
    }

    protected void initialize() {
        this.tree = new JTree();
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    protected void performLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }
}

