/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsObject;
import rossi.fstoolsui.fstree.FileViewPanel;
import rossi.fstoolsui.fstree.FsObjectTreeNode;
import rossi.fstoolsui.fstree.FsTree;
import rossi.fstoolsui.fstree.InodeTablePanel;

public class FsViewPanel
extends JPanel
implements TreeSelectionListener {
    protected FsTree fstree;
    protected InodeTablePanel inodePanel;
    protected FileViewPanel fileViewPanel;
    protected FsObject currentFsObj = null;
    protected String currentFname = null;
    protected JLabel pathLbl;
    protected List listSelectionListeners = new ArrayList();

    public FsViewPanel() {
        this.initialize();
        this.performLayout();
    }

    protected void initialize() {
        this.fstree = new FsTree();
        this.fstree.addTreeSelectionListener(this);
        this.inodePanel = new InodeTablePanel();
        this.fileViewPanel = new FileViewPanel();
        this.pathLbl = new JLabel("/");
        this.inodePanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArrayList<FsObjectTreeNode> list = new ArrayList<FsObjectTreeNode>();
                FsObjectTreeNode node = FsViewPanel.this.inodePanel.getFsObjectNode();
                do {
                    list.add(node);
                } while (node.getParent() instanceof FsObjectTreeNode && !(node = (FsObjectTreeNode)node.getParent()).toString().equals("/"));
                Collections.reverse(list);
                StringBuffer sb = new StringBuffer();
                Iterator itr = list.iterator();
                while (itr.hasNext()) {
                    node = (FsObjectTreeNode)itr.next();
                    sb.append("/");
                    sb.append(node.toString());
                }
                FsViewPanel.this.pathLbl.setText(sb.toString());
            }
        });
        this.inodePanel.getTable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 1) {
                    try {
                        FsObject fsobj = FsViewPanel.this.inodePanel.getSelectedFsObject();
                        FsViewPanel.this.setCurrentFsObj(fsobj, FsViewPanel.this.inodePanel.getSelectedFilename());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    protected void performLayout() {
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.fstree);
        JSplitPane fsplitter = new JSplitPane(0, false, this.inodePanel, this.fileViewPanel);
        fsplitter.setDividerLocation(200);
        JSplitPane splitter = new JSplitPane(1, false, sp, fsplitter);
        splitter.setDividerLocation(100);
        this.add((Component)splitter, "Center");
        this.add((Component)this.pathLbl, "South");
    }

    public void setFileSystem(FileSystem fs) throws Exception {
        this.fstree.setFileSystem(fs);
        this.inodePanel.setFileSystem(fs);
    }

    public FileSystem getFileSystem() {
        return this.inodePanel.getFileSystem();
    }

    public FsObject getCurrentFsObject() {
        return this.currentFsObj;
    }

    public String getCurrentFilename() {
        return this.currentFname;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.remove(listener);
    }

    protected void fireListSelectionEvent(ListSelectionEvent evt) {
        Iterator itr = this.listSelectionListeners.iterator();
        while (itr.hasNext()) {
            ListSelectionListener al = (ListSelectionListener)itr.next();
            al.valueChanged(evt);
        }
    }

    protected void setCurrentFsObj(FsObject fsobj, String name) {
        this.currentFsObj = fsobj;
        this.currentFname = name;
        if (this.currentFsObj instanceof File) {
            Cursor c = this.getCursor();
            this.setCursor(new Cursor(3));
            this.fileViewPanel.setFile((File)this.currentFsObj);
            this.setCursor(c);
        }
        this.fireListSelectionEvent(new ListSelectionEvent(this, 0, 0, false));
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node instanceof FsObjectTreeNode) {
            FsObjectTreeNode fnode = (FsObjectTreeNode)node;
            if (!fnode.isLeaf()) {
                this.inodePanel.setFsObjectNode(fnode);
            }
            this.setCurrentFsObj(fnode.getFsObject(), fnode.getName());
        }
    }
}

