/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.Inode;

public class InodeTableModel
extends AbstractTableModel {
    protected List nameList;
    protected Map inodeMap;
    protected DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected FileSystem fs;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public InodeTableModel(List l, Map m) {
        this.nameList = l;
        this.inodeMap = m;
    }

    public void setFileSystem(FileSystem aFs) {
        this.fs = aFs;
    }

    public int getRowCount() {
        return this.nameList.size();
    }

    public int getColumnCount() {
        return 9;
    }

    public String getColumnName(int col) {
        String[] colnames = new String[]{"Name", "Mode", "Links", "User", "Group", "Size", "Modified", "Accessed", "Changed"};
        return colnames[col];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = InodeTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 5: {
                return class$java$lang$Long == null ? (class$java$lang$Long = InodeTableModel.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 6: 
            case 7: 
            case 8: {
                return class$java$util$Date == null ? (class$java$util$Date = InodeTableModel.class$("java.util.Date")) : class$java$util$Date;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = InodeTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        String name = (String)this.nameList.get(row);
        return this.cellFromName(name, col);
    }

    public Object cellFromName(String name, int col) {
        Inode inode = (Inode)this.inodeMap.get(name);
        switch (col) {
            case 0: {
                return name;
            }
            case 1: {
                return new Integer(inode.getMode());
            }
            case 2: {
                return new Integer((int)inode.getNumLinks());
            }
            case 3: {
                return new Integer((int)inode.getUserId());
            }
            case 4: {
                return new Integer((int)inode.getGroupId());
            }
            case 5: {
                return new Long(inode.getSize());
            }
            case 6: {
                return new Date(inode.getModifyTime() * 1000L);
            }
            case 7: {
                return new Date(inode.getAccessTime() * 1000L);
            }
            case 8: {
                return new Date(inode.getChangedTime() * 1000L);
            }
        }
        return "";
    }

    public void setValueAt(Object obj, int row, int col) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

