/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.io.BlockIO;
import rossi.fstools.partition.Partition;
import rossi.fstoolsui.fstree.FsViewFrame;
import rossi.fstoolsui.fstree.PartitionTablePanel;

public class OpenPartitionDialog
extends JDialog {
    protected JComboBox driveCB;
    protected JComboBox fsCB;
    protected PartitionTablePanel partitionTable;
    protected JButton okBTN;
    protected JButton cancelBTN;
    protected FsViewFrame fsViewFrame;
    protected static final String[] LINUX_DEVICES = new String[]{"/dev/hda", "/dev/hdb", "/dev/hdc", "/dev/hdd"};
    protected static final String[] WINDOWS_DEVICES = new String[]{"\\\\.\\PhysicalDrive0", "\\\\.\\PhysicalDrive1", "\\\\.\\PhysicalDrive2", "\\\\.\\PhysicalDrive3"};
    protected static Map deviceMap = new HashMap();
    protected static Map fsMap;

    public OpenPartitionDialog(FsViewFrame parent) {
        super((Frame)parent, "Open disk partition");
        this.fsViewFrame = parent;
        this.initialize();
        this.performLayout();
    }

    protected void initialize() {
        this.driveCB = new JComboBox<String>((String[])deviceMap.get(System.getProperty("os.name")));
        this.driveCB.setEditable(true);
        this.driveCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenPartitionDialog.this.partitionTable.setDisk((String)OpenPartitionDialog.this.driveCB.getSelectedItem());
            }
        });
        Object[] fileSystems = fsMap.keySet().toArray(new String[0]);
        Arrays.sort(fileSystems);
        this.fsCB = new JComboBox<Object>(fileSystems);
        this.partitionTable = new PartitionTablePanel();
        this.partitionTable.setDisk((String)this.driveCB.getSelectedItem());
        this.partitionTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenPartitionDialog.this.openFileSystem();
            }
        });
        this.okBTN = new JButton("Ok");
        this.okBTN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenPartitionDialog.this.openFileSystem();
            }
        });
        this.cancelBTN = new JButton("Cancel");
        this.cancelBTN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenPartitionDialog.this.setVisible(false);
                OpenPartitionDialog.this.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openFileSystem() {
        Cursor cursor = this.getCursor();
        try {
            Class<?> fsClass = Class.forName((String)fsMap.get((String)this.fsCB.getSelectedItem()));
            FileSystem fs = (FileSystem)fsClass.newInstance();
            this.setCursor(new Cursor(3));
            Partition part = this.partitionTable.getSelectedPartition();
            long offset = part.getStartLBA() * 512L;
            RandomAccessFile rafile = new RandomAccessFile((String)this.driveCB.getSelectedItem(), "r");
            BlockIO blkio = new BlockIO(rafile, 4096, offset);
            fs.open(blkio);
            int partid = this.partitionTable.getSelectedPartitionOrdinal();
            this.fsViewFrame.setTitle((String)this.driveCB.getSelectedItem() + " partition " + partid);
            this.fsViewFrame.setFileSystem(fs);
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getClass().getName() + ": " + ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(cursor);
        }
    }

    protected void performLayout() {
        JPanel mainPnl = new JPanel();
        JPanel buttonPnl = new JPanel();
        GridBagLayout gridb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        buttonPnl.setLayout(new FlowLayout());
        buttonPnl.add(this.okBTN);
        buttonPnl.add(this.cancelBTN);
        mainPnl.setLayout(gridb);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JComponent comp = new JLabel("Drive:");
        gridb.setConstraints(comp, c);
        mainPnl.add(comp);
        c.gridx = 1;
        c.gridy = 0;
        comp = this.driveCB;
        gridb.setConstraints(comp, c);
        mainPnl.add(comp);
        c.gridx = 0;
        c.gridy = 1;
        comp = new JLabel("File System:");
        gridb.setConstraints(comp, c);
        mainPnl.add(comp);
        c.gridx = 1;
        c.gridy = 1;
        comp = this.fsCB;
        gridb.setConstraints(comp, c);
        mainPnl.add(comp);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        comp = this.partitionTable;
        gridb.setConstraints(comp, c);
        mainPnl.add(comp);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        comp = buttonPnl;
        gridb.setConstraints(comp, c);
        mainPnl.add(comp);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPnl, "Center");
    }

    static {
        deviceMap.put("Linux", LINUX_DEVICES);
        deviceMap.put("Windows NT", WINDOWS_DEVICES);
        deviceMap.put("Windows 2000", WINDOWS_DEVICES);
        deviceMap.put("Windows XP", WINDOWS_DEVICES);
        fsMap = new HashMap();
        fsMap.put("Ext2/3", "rossi.fstools.fs.ext2fs.Ext2FileSystem");
        fsMap.put("FAT 12/16/32", "rossi.fstools.fs.fatfs.FatFileSystem");
        fsMap.put("Reiser", "rossi.fstools.fs.reiserfs.ReiserFileSystem");
    }
}

