/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import rossi.fstools.partition.Partition;

public class PartitionTableModel
extends AbstractTableModel {
    protected List partitionList;
    protected DecimalFormat nf = new DecimalFormat("###.#");
    protected Properties partTypes;
    static /* synthetic */ Class class$java$lang$String;

    public PartitionTableModel(List pList) {
        this.loadPartitions(pList);
        this.loadPartitionTypes();
    }

    public int getRowCount() {
        return this.partitionList.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int col) {
        String[] colnames = new String[]{"#", "System", "Size"};
        return colnames[col];
    }

    public Class getColumnClass(int col) {
        return class$java$lang$String == null ? (class$java$lang$String = PartitionTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        NumberedPartition part = (NumberedPartition)this.partitionList.get(row);
        return this.cellFromPartition(part, col);
    }

    public Object cellFromPartition(NumberedPartition part, int col) {
        switch (col) {
            case 0: {
                return Integer.toString(part.getOrdinal());
            }
            case 1: {
                return this.getPartitionTypeString(part.getPartition());
            }
            case 2: {
                return this.getPartSizeString(part.getPartition());
            }
        }
        return "";
    }

    public void setValueAt(Object obj, int row, int col) {
    }

    public Partition getPartitionForRow(int row) {
        NumberedPartition npart = (NumberedPartition)this.partitionList.get(row);
        return npart.getPartition();
    }

    public int getPartitionOrdinalForRow(int row) {
        NumberedPartition npart = (NumberedPartition)this.partitionList.get(row);
        return npart.getOrdinal();
    }

    protected String getPartSizeString(Partition part) {
        double size = part.getNumLBASector() * 512L;
        if ((size /= 1000000.0) < 1000.0) {
            return this.nf.format(size) + " MB";
        }
        return this.nf.format(size /= 1000.0) + " GB";
    }

    protected String getPartitionTypeString(Partition part) {
        String id = Integer.toHexString(part.getSystem() & 0xFF);
        String desc = this.partTypes.getProperty(id);
        if (desc == null) {
            return id;
        }
        return id + ": " + desc;
    }

    protected void loadPartitionTypes() {
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("systypes.properties");
            this.partTypes = new Properties();
            this.partTypes.load(in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadPartitions(List pList) {
        int ordinal = 0;
        this.partitionList = new ArrayList();
        Iterator itr = pList.iterator();
        while (itr.hasNext()) {
            Partition p = (Partition)itr.next();
            ++ordinal;
            if (p.isExtended() || p.getNumLBASector() == 0L) continue;
            NumberedPartition npart = new NumberedPartition(ordinal, p);
            this.partitionList.add(npart);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NumberedPartition {
        protected int ordinal;
        protected Partition part;

        public NumberedPartition(int ordinal, Partition p) {
            this.ordinal = ordinal;
            this.part = p;
        }

        public Partition getPartition() {
            return this.part;
        }

        public void setPartition(Partition aPart) {
            this.part = aPart;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(int aOrdinal) {
            this.ordinal = aOrdinal;
        }
    }
}

