/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstoolsui.fstree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rossi.fstools.io.BlockIO;
import rossi.fstools.partition.Partition;
import rossi.fstools.partition.PhysicalDisk;
import rossi.fstoolsui.fstree.PartitionTableModel;

public class PartitionTablePanel
extends JPanel
implements MouseListener {
    protected JTable tbl;
    protected TableModel model;
    protected String diskName;
    protected List actionListeners = new ArrayList();

    public PartitionTablePanel() {
        this.initialize();
    }

    protected void initialize() {
        this.model = this.getModel(null);
        TableColumnModel cm = this.getColumnModel(this.model);
        this.tbl = new JTable(this.model, cm);
        this.tbl.setSurrendersFocusOnKeystroke(true);
        this.tbl.setAutoResizeMode(0);
        this.tbl.addMouseListener(this);
        this.tbl.getTableHeader().addMouseListener(this);
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.tbl);
        this.add((Component)sp, "Center");
    }

    public void setDisk(String diskName) {
        this.diskName = diskName;
        this.model = this.getModel(diskName);
        this.tbl.setModel(this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected TableModel getModel(String dName) {
        RandomAccessFile rafile = null;
        if (dName == null) {
            return new PartitionTableModel(new ArrayList());
        }
        rafile = new RandomAccessFile(dName, "r");
        BlockIO blkio = new BlockIO(rafile, 512);
        PhysicalDisk disk = new PhysicalDisk();
        disk.open(blkio);
        Partition[] parts = disk.getPartitions();
        PartitionTableModel partitionTableModel = new PartitionTableModel(Arrays.asList(parts));
        Object var8_8 = null;
        try {
            if (rafile != null) {
                rafile.close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return partitionTableModel;
        catch (Exception ex) {
            try {
                JOptionPane.showMessageDialog(this, ex.getClass().getName() + ": " + ex.getMessage(), "Error", 0);
                ex.printStackTrace();
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (rafile != null) {
                        rafile.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (rafile != null) {
                    rafile.close();
                }
            }
            catch (Exception ex2) {}
        }
        return new PartitionTableModel(new ArrayList());
    }

    protected TableColumnModel getColumnModel(TableModel model) {
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        int[] width = new int[]{45, 170, 60};
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn c = new TableColumn(i, width[i]);
            c.setHeaderValue(model.getColumnName(i));
            cm.addColumn(c);
        }
        return cm;
    }

    public Partition getSelectedPartition() {
        int row = this.tbl.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return ((PartitionTableModel)this.model).getPartitionForRow(row);
    }

    public int getSelectedPartitionOrdinal() {
        int row = this.tbl.getSelectedRow();
        if (row == -1) {
            return 0;
        }
        return ((PartitionTableModel)this.model).getPartitionOrdinalForRow(row);
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            this.handleDoubleClick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionEvent() {
        ActionEvent evt = new ActionEvent(this, 1001, "cmd");
        List list = this.actionListeners;
        synchronized (list) {
            Iterator itr = this.actionListeners.iterator();
            while (itr.hasNext()) {
                ActionListener al = (ActionListener)itr.next();
                al.actionPerformed(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener al) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(al);
        }
    }

    protected void handleDoubleClick() {
        this.fireActionEvent();
    }

    public JTable getTable() {
        return this.tbl;
    }
}

