/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.Device;
import rossi.fstools.fs.ext2fs.Ext2Inode;

public class Ext2Device
implements Device {
    private boolean blockDev = false;
    private boolean charDev = false;
    private int major;
    private int minor;

    public Ext2Device(Ext2Inode inode) {
        int dev;
        if ((inode.getMode() & 0xF000) == 8192) {
            this.charDev = true;
        }
        if ((inode.getMode() & 0xF000) == 24576) {
            this.blockDev = true;
        }
        if ((dev = (int)inode.getDirectBlock(0)) != 0) {
            this.major = (dev & 0xFF00) >> 8;
            this.minor = dev & 0xFF;
        } else {
            dev = (int)inode.getDirectBlock(1);
            this.major = (dev & 0xFFF00) >> 8;
            this.minor = dev & 0xFF | dev >> 12 & 0xFFF00;
        }
    }

    public boolean isBlockDev() {
        return this.blockDev;
    }

    public boolean isCharDev() {
        return this.charDev;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

