/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import java.io.IOException;
import rossi.fstools.fs.Device;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;
import rossi.fstools.fs.SuperBlock;
import rossi.fstools.fs.SymLink;
import rossi.fstools.fs.ext2fs.Ext2Device;
import rossi.fstools.fs.ext2fs.Ext2Directory;
import rossi.fstools.fs.ext2fs.Ext2FastSymLink;
import rossi.fstools.fs.ext2fs.Ext2Fifo;
import rossi.fstools.fs.ext2fs.Ext2File;
import rossi.fstools.fs.ext2fs.Ext2Inode;
import rossi.fstools.fs.ext2fs.Ext2InodePtr;
import rossi.fstools.fs.ext2fs.Ext2SlowSymLink;
import rossi.fstools.fs.ext2fs.Ext2Socket;
import rossi.fstools.fs.ext2fs.Ext2SuperBlock;
import rossi.fstools.fs.ext2fs.GroupDesc;
import rossi.fstools.io.BlockReader;

public class Ext2FileSystem
implements FileSystem {
    private BlockReader blockReader;
    private Ext2SuperBlock sb;
    public static final long EXT2_BAD_INO = 1L;
    public static final long EXT2_ROOT_INO = 2L;

    public SuperBlock open(BlockReader br) throws FsException, IOException {
        this.blockReader = br;
        br.setBlockSize(1024);
        this.sb = new Ext2SuperBlock();
        this.sb.loadFromBuffer(br.getBlock(1), 0);
        br.setBlockSize((int)this.sb.getBlockSize());
        return this.sb;
    }

    public void close() throws IOException {
        this.blockReader.close();
    }

    public InodePtr getRootDir() {
        return new Ext2InodePtr(2L);
    }

    public Inode getInode(InodePtr ptr) throws FsException, IOException {
        long inodeNumber = ((Ext2InodePtr)ptr).getNumber() - 1L;
        if (inodeNumber < 0L) {
            return null;
        }
        long inodesPerGroup = this.sb.getInodesPerGroup();
        long groupNum = inodeNumber / inodesPerGroup;
        long groupOffset = inodeNumber % inodesPerGroup;
        GroupDesc groupDesc = this.getGroupDescriptor((int)groupNum);
        long inodeTableStart = groupDesc.getInodeTable();
        long inodesPerBlock = this.sb.getBlockSize() / (long)this.sb.getInodeSize();
        long inodeTableBlock = groupOffset / inodesPerBlock + inodeTableStart;
        long inodeTableBlockOffset = groupOffset % inodesPerBlock;
        byte[] buffer = this.blockReader.getBlock((int)inodeTableBlock);
        Ext2Inode inode = new Ext2Inode();
        inode.loadFromBuffer(buffer, (int)(inodeTableBlockOffset * (long)this.sb.getInodeSize()));
        return inode;
    }

    private GroupDesc getGroupDescriptor(int groupno) throws FsException, IOException {
        int firstGroupBlock = this.sb.getBlockSize() == 1024L ? 2 : 1;
        GroupDesc gd = new GroupDesc();
        int groupSize = gd.getDataSize();
        int groupsPerBlock = (int)this.sb.getBlockSize() / groupSize;
        int groupBlock = groupno / groupsPerBlock;
        int groupOffset = groupno % groupsPerBlock;
        byte[] buffer = this.blockReader.getBlock(groupBlock + firstGroupBlock);
        gd.loadFromBuffer(buffer, groupOffset * groupSize);
        return gd;
    }

    public File createExt2File(Ext2Inode inode) throws FsException, IOException {
        long blockno;
        long fileSize = inode.getSize();
        Ext2File file = new Ext2File(this.sb, fileSize, this.blockReader);
        for (int i = 0; i < Ext2Inode.EXT2_NDIR_BLOCKS && (blockno = inode.getDirectBlock(i)) != 0L; ++i) {
            file.addDirectBlock(blockno);
        }
        blockno = inode.getIndirectBlock();
        if (blockno != 0L) {
            file.addIndirectBlock(blockno, 1);
        }
        if ((blockno = inode.getDoubleIndirectBlock()) != 0L) {
            file.addIndirectBlock(blockno, 2);
        }
        if ((blockno = inode.getTripleIndirectBlock()) != 0L) {
            file.addIndirectBlock(blockno, 3);
        }
        return file;
    }

    public Directory createExt2Directory(Ext2Inode inode) throws FsException, IOException {
        return new Ext2Directory(this.createExt2File(inode));
    }

    public Device createExt2Device(Ext2Inode inode) {
        return new Ext2Device(inode);
    }

    public SymLink createExt2SymLink(Ext2Inode inode) throws FsException, IOException {
        if (inode.getBlocks() == 0L) {
            return new Ext2FastSymLink(inode);
        }
        return new Ext2SlowSymLink(this.createExt2File(inode));
    }

    public FsObject getObject(Inode inode) throws FsException, IOException {
        int fileType = inode.getMode() & 0xF000;
        switch (fileType) {
            case 16384: {
                return this.createExt2Directory((Ext2Inode)inode);
            }
            case 32768: {
                return this.createExt2File((Ext2Inode)inode);
            }
            case 40960: {
                return this.createExt2SymLink((Ext2Inode)inode);
            }
            case 24576: {
                return this.createExt2Device((Ext2Inode)inode);
            }
            case 8192: {
                return this.createExt2Device((Ext2Inode)inode);
            }
            case 49152: {
                return new Ext2Socket();
            }
            case 4096: {
                return new Ext2Fifo();
            }
        }
        throw new FsException("Unsupported file type " + fileType);
    }
}

