/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.ext2fs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.SuperBlock;
import rossi.fstools.fs.ext2fs.Ext2Inode;

public class Ext2SuperBlock
implements SuperBlock {
    protected long inodeCount;
    protected long blockCount;
    protected long reservedBlockCount;
    protected long freeBlocks;
    protected long freeInodes;
    protected long firstDataBlock;
    protected long logBlockSize;
    protected long logFragSize;
    protected long blocksPerGroup;
    protected long fragsPerGroup;
    protected long inodesPerGroup;
    protected long mountTime;
    protected long writeTime;
    protected int mountCount;
    protected int maxMountCount;
    protected int magic;
    protected int state;
    protected int errors;
    protected int minorRevLevel;
    protected long lastCheck;
    protected long checkInterval;
    protected long creatorOS;
    protected long revLevel;
    protected int defaultResUID;
    protected int defaultResGID;
    protected long firstInode;
    protected int inodeSize;
    protected int groupNumber;
    protected long featureCompat;
    protected long featureInCompat;
    protected long featureROCompat;
    protected byte[] uniqueID;
    protected byte[] label;
    protected byte[] lastMountPoint;
    protected long algorithmUsageBitmap;
    protected byte preallocBlocks;
    protected byte preallocDirBlocks;
    protected byte[] journalUniqueID;
    protected long journalInode;
    protected long journalDev;
    protected long lastOrphan;
    protected int[] hashSeed;
    protected byte defaultHashVersion;
    protected byte reservedCharPad;
    protected int reservedWordPad;
    protected long defaultMountOptions;
    protected long firstMetaBlockGroup;
    public static final int EXT2_GOOD_OLD_REV = 0;
    public static final int EXT2_DYNAMIC_REV = 1;
    public static final int EXT2_GOOD_OLD_INODE_SIZE = 128;
    public static final int EXT2_MAX_SUPPORTED_REV = 1;
    public static final int EXT2_FEATURE_COMPAT_DIR_PREALLOC = 1;
    public static final int EXT2_FEATURE_COMPAT_IMAGIC_INODES = 2;
    public static final int EXT2_FEATURE_COMPAT_HAS_JOURNAL = 4;
    public static final int EXT2_FEATURE_COMPAT_EXT_ATTR = 8;
    public static final int EXT2_FEATURE_COMPAT_RESIZE_INODE = 16;
    public static final int EXT2_FEATURE_COMPAT_DIR_INDEX = 32;
    public static final int EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER = 1;
    public static final int EXT2_FEATURE_RO_COMPAT_LARGE_FILE = 2;
    public static final int EXT2_FEATURE_RO_COMPAT_BTREE_DIR = 4;
    public static final int EXT2_FEATURE_INCOMPAT_COMPRESSION = 1;
    public static final int EXT2_FEATURE_INCOMPAT_FILETYPE = 2;
    public static final int EXT2_FEATURE_INCOMPAT_RECOVER = 4;
    public static final int EXT2_FEATURE_INCOMPAT_JOURNAL_DEV = 8;
    public static final int EXT2_FEATURE_INCOMPAT_META_BG = 16;
    public static final int EXT2_SUPER_MAGIC = 61267;
    public static final int EXT2_MIN_BLOCK_SIZE = 1024;
    public static final int EXT2_MAX_BLOCK_SIZE = 4096;

    public int getDataSize() {
        return 1024;
    }

    public long getInodeCount() {
        return this.inodeCount;
    }

    public void setInodeCount(long aInodeCount) {
        this.inodeCount = aInodeCount;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(long aBlockCount) {
        this.blockCount = aBlockCount;
    }

    public long getReservedBlockCount() {
        return this.reservedBlockCount;
    }

    public void setReservedBlockCount(long aReservedBlockCount) {
        this.reservedBlockCount = aReservedBlockCount;
    }

    public long getFreeBlocks() {
        return this.freeBlocks;
    }

    public void setFreeBlocks(long aFreeBlocks) {
        this.freeBlocks = aFreeBlocks;
    }

    public long getFreeInodes() {
        return this.freeInodes;
    }

    public void setFreeInodes(long aFreeInodes) {
        this.freeInodes = aFreeInodes;
    }

    public long getFirstDataBlock() {
        return this.firstDataBlock;
    }

    public void setFirstDataBlock(long aFirstDataBlock) {
        this.firstDataBlock = aFirstDataBlock;
    }

    public long getLogBlockSize() {
        return this.logBlockSize;
    }

    public void setLogBlockSize(long aLogBlockSize) {
        this.logBlockSize = aLogBlockSize;
    }

    public long getBlockSize() {
        return 1024 << (int)this.getLogBlockSize();
    }

    public long getLogFragSize() {
        return this.logFragSize;
    }

    public void setLogFragSize(long aLogFragSize) {
        this.logFragSize = aLogFragSize;
    }

    public long getFragSize() {
        return 1024 << (int)this.getLogBlockSize();
    }

    public long getBlocksPerGroup() {
        return this.blocksPerGroup;
    }

    public void setBlocksPerGroup(long aBlocksPerGroup) {
        this.blocksPerGroup = aBlocksPerGroup;
    }

    public long getFragsPerGroup() {
        return this.fragsPerGroup;
    }

    public void setFragsPerGroup(long aFragsPerGroup) {
        this.fragsPerGroup = aFragsPerGroup;
    }

    public long getInodesPerGroup() {
        return this.inodesPerGroup;
    }

    public void setInodesPerGroup(long aInodesPerGroup) {
        this.inodesPerGroup = aInodesPerGroup;
    }

    public long getMountTime() {
        return this.mountTime;
    }

    public void setMountTime(long aMountTime) {
        this.mountTime = aMountTime;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public void setWriteTime(long aWriteTime) {
        this.writeTime = aWriteTime;
    }

    public int getMountCount() {
        return this.mountCount;
    }

    public void setMountCount(int aMountCount) {
        this.mountCount = aMountCount;
    }

    public int getMaxMountCount() {
        return this.maxMountCount;
    }

    public void setMaxMountCount(int aMaxMountCount) {
        this.maxMountCount = aMaxMountCount;
    }

    public int getMagic() {
        return this.magic;
    }

    public void setMagic(int aMagic) {
        this.magic = aMagic;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int aState) {
        this.state = aState;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int aErrors) {
        this.errors = aErrors;
    }

    public int getMinorRevLevel() {
        return this.minorRevLevel;
    }

    public void setMinorRevLevel(int aMinorRevLevel) {
        this.minorRevLevel = aMinorRevLevel;
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public void setLastCheck(long aLastCheck) {
        this.lastCheck = aLastCheck;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long aCheckInterval) {
        this.checkInterval = aCheckInterval;
    }

    public long getCreatorOS() {
        return this.creatorOS;
    }

    public void setCreatorOS(long aCreatorOS) {
        this.creatorOS = aCreatorOS;
    }

    public long getRevLevel() {
        return this.revLevel;
    }

    public void setRevLevel(long aRevLevel) {
        this.revLevel = aRevLevel;
    }

    public int getDefaultResUID() {
        return this.defaultResUID;
    }

    public void setDefaultResUID(int aDefaultResUID) {
        this.defaultResUID = aDefaultResUID;
    }

    public int getDefaultResGID() {
        return this.defaultResGID;
    }

    public void setDefaultResGID(int aDefaultResGID) {
        this.defaultResGID = aDefaultResGID;
    }

    public long getFirstInode() {
        return this.firstInode;
    }

    public void setFirstInode(long aFirstInode) {
        this.firstInode = aFirstInode;
    }

    public int getInodeSize() {
        if (this.revLevel == 0L) {
            return Ext2Inode.EXT2_GOOD_OLD_INODE_SIZE;
        }
        return this.inodeSize;
    }

    public void setInodeSize(int aInodeSize) {
        this.inodeSize = aInodeSize;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(int aGroupNumber) {
        this.groupNumber = aGroupNumber;
    }

    public long getFeatureCompat() {
        return this.featureCompat;
    }

    public void setFeatureCompat(long aFeatureCompat) {
        this.featureCompat = aFeatureCompat;
    }

    public long getFeatureInCompat() {
        return this.featureInCompat;
    }

    public void setFeatureInCompat(long aFeatureInCompat) {
        this.featureInCompat = aFeatureInCompat;
    }

    public long getFeatureROCompat() {
        return this.featureROCompat;
    }

    public void setFeatureROCompat(long aFeatureROCompat) {
        this.featureROCompat = aFeatureROCompat;
    }

    public byte[] getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(byte[] aUniqueID) {
        this.uniqueID = aUniqueID;
    }

    public byte[] getLabel() {
        return this.label;
    }

    public void setLabel(byte[] aLabel) {
        this.label = aLabel;
    }

    public byte[] getLastMountPoint() {
        return this.lastMountPoint;
    }

    public void setLastMountPoint(byte[] aLastMountPoint) {
        this.lastMountPoint = aLastMountPoint;
    }

    public long getAlgorithmUsageBitmap() {
        return this.algorithmUsageBitmap;
    }

    public void setAlgorithmUsageBitmap(long aAlgorithmUsageBitmap) {
        this.algorithmUsageBitmap = aAlgorithmUsageBitmap;
    }

    public byte getPreallocBlocks() {
        return this.preallocBlocks;
    }

    public void setPreallocBlocks(byte aPreallocBlocks) {
        this.preallocBlocks = aPreallocBlocks;
    }

    public byte getPreallocDirBlocks() {
        return this.preallocDirBlocks;
    }

    public void setPreallocDirBlocks(byte aPreallocDirBlocks) {
        this.preallocDirBlocks = aPreallocDirBlocks;
    }

    public byte[] getJournalUniqueID() {
        return this.journalUniqueID;
    }

    public void setJournalUniqueID(byte[] aJournalUniqueID) {
        this.journalUniqueID = aJournalUniqueID;
    }

    public long getJournalInode() {
        return this.journalInode;
    }

    public void setJournalInode(long aJournalInode) {
        this.journalInode = aJournalInode;
    }

    public long getJournalDev() {
        return this.journalDev;
    }

    public void setJournalDev(long aJournalDev) {
        this.journalDev = aJournalDev;
    }

    public long getLastOrphan() {
        return this.lastOrphan;
    }

    public void setLastOrphan(long aLastOrphan) {
        this.lastOrphan = aLastOrphan;
    }

    public int[] getHashSeed() {
        return this.hashSeed;
    }

    public void setHashSeed(int[] aHashSeed) {
        this.hashSeed = aHashSeed;
    }

    public byte getDefaultHashVersion() {
        return this.defaultHashVersion;
    }

    public void setDefaultHashVersion(byte aDefaultHashVersion) {
        this.defaultHashVersion = aDefaultHashVersion;
    }

    public byte getReservedCharPad() {
        return this.reservedCharPad;
    }

    public void setReservedCharPad(byte aReservedCharPad) {
        this.reservedCharPad = aReservedCharPad;
    }

    public int getReservedWordPad() {
        return this.reservedWordPad;
    }

    public void setReservedWordPad(int aReservedWordPad) {
        this.reservedWordPad = aReservedWordPad;
    }

    public long getDefaultMountOptions() {
        return this.defaultMountOptions;
    }

    public void setDefaultMountOptions(long aDefaultMountOptions) {
        this.defaultMountOptions = aDefaultMountOptions;
    }

    public long getFirstMetaBlockGroup() {
        return this.firstMetaBlockGroup;
    }

    public void setFirstMetaBlockGroup(long aFirstMetaBlockGroup) {
        this.firstMetaBlockGroup = aFirstMetaBlockGroup;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        if (buffer.length < offset + this.getDataSize()) {
            throw new FsException("Insufficinet buffer to load super-block");
        }
        this.setInodeCount(FsUtils.getU32(buffer, offset + 0));
        this.setBlockCount(FsUtils.getU32(buffer, offset + 4));
        this.setReservedBlockCount(FsUtils.getU32(buffer, offset + 8));
        this.setFreeBlocks(FsUtils.getU32(buffer, offset + 12));
        this.setFreeInodes(FsUtils.getU32(buffer, offset + 16));
        this.setFirstDataBlock(FsUtils.getU32(buffer, offset + 20));
        this.setLogBlockSize(FsUtils.getU32(buffer, offset + 24));
        this.setLogFragSize(FsUtils.getS32(buffer, offset + 28));
        this.setBlocksPerGroup(FsUtils.getU32(buffer, offset + 32));
        this.setFragsPerGroup(FsUtils.getU32(buffer, offset + 36));
        this.setInodesPerGroup(FsUtils.getU32(buffer, offset + 40));
        this.setMountTime(FsUtils.getU32(buffer, offset + 44));
        this.setWriteTime(FsUtils.getU32(buffer, offset + 48));
        this.setMountCount(FsUtils.getU16(buffer, offset + 52));
        this.setMaxMountCount(FsUtils.getS16(buffer, offset + 54));
        this.setMagic(FsUtils.getU16(buffer, offset + 56));
        this.setState(FsUtils.getU16(buffer, offset + 58));
        this.setErrors(FsUtils.getU16(buffer, offset + 60));
        this.setMinorRevLevel(FsUtils.getU16(buffer, offset + 62));
        this.setLastCheck(FsUtils.getU32(buffer, offset + 64));
        this.setCheckInterval(FsUtils.getU32(buffer, offset + 68));
        this.setCreatorOS(FsUtils.getU32(buffer, offset + 72));
        this.setRevLevel(FsUtils.getU32(buffer, offset + 76));
        this.setDefaultResUID(FsUtils.getU16(buffer, offset + 80));
        this.setDefaultResGID(FsUtils.getU16(buffer, offset + 82));
        if (this.revLevel >= 1L) {
            this.setFirstInode(FsUtils.getU32(buffer, offset + 84));
            this.setInodeSize(FsUtils.getU16(buffer, offset + 88));
            this.setGroupNumber(FsUtils.getU16(buffer, offset + 90));
            this.setFeatureCompat(FsUtils.getU32(buffer, offset + 92));
            this.setFeatureInCompat(FsUtils.getU32(buffer, offset + 96));
            this.setFeatureROCompat(FsUtils.getU32(buffer, offset + 100));
            this.uniqueID = new byte[16];
            System.arraycopy(buffer, offset + 104, this.uniqueID, 0, 16);
            this.label = new byte[16];
            System.arraycopy(buffer, offset + 120, this.label, 0, 16);
            this.lastMountPoint = new byte[64];
            System.arraycopy(buffer, offset + 136, this.lastMountPoint, 0, 64);
            this.setAlgorithmUsageBitmap(FsUtils.getU32(buffer, offset + 200));
            this.setPreallocBlocks(buffer[offset + 204]);
            this.setPreallocDirBlocks(buffer[offset + 205]);
            this.journalUniqueID = new byte[16];
            System.arraycopy(buffer, offset + 208, this.journalUniqueID, 0, 16);
            this.setJournalInode(FsUtils.getU32(buffer, offset + 224));
            this.setJournalDev(FsUtils.getU32(buffer, offset + 228));
            this.setLastOrphan(FsUtils.getU32(buffer, offset + 232));
        }
        try {
            if (this.magic != 61267) {
                throw new FsException("Invalid magic.");
            }
            if (this.revLevel < 0L || this.revLevel > 1L) {
                throw new FsException("Unsupported Version " + this.revLevel);
            }
            if (this.revLevel >= 1L) {
                if ((this.featureInCompat & 1L) != 0L) {
                    throw new FsException("Compression not supported");
                }
                if ((this.featureInCompat & 0x10L) != 0L) {
                    throw new FsException("Meta Block not supported");
                }
            }
        }
        catch (Exception ex) {
            FsException fex = new FsException("Error processing superblock.");
            fex.initCause(ex);
            throw fex;
        }
    }
}

