/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;

public class FatDirEntry
implements DiskStructure,
Inode,
InodePtr {
    protected byte[] name;
    protected byte[] ext;
    protected byte attr;
    protected byte lcase;
    protected int ctimems;
    protected int ctime;
    protected int cdate;
    protected int adate;
    protected int starthi;
    protected int time;
    protected int date;
    protected int start;
    protected long size;
    protected byte hashValue;
    protected String longName;
    private static final int[] day_n = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 0, 0, 0, 0};
    public static final int ATTR_NONE = 0;
    public static final int ATTR_RO = 1;
    public static final int ATTR_HIDDEN = 2;
    public static final int ATTR_SYS = 4;
    public static final int ATTR_VOLUME = 8;
    public static final int ATTR_DIR = 16;
    public static final int ATTR_ARCH = 32;
    public static final int ATTR_LFN = 15;
    public static final int CASE_LOWER_BASE = 8;
    public static final int CASE_LOWER_EXT = 16;

    public int getDataSize() {
        return 32;
    }

    public byte[] getNamePrefix() {
        return this.name;
    }

    public void setNamePrefix(byte[] aName) {
        this.name = aName;
    }

    public byte[] getExt() {
        return this.ext;
    }

    public void setExt(byte[] aExt) {
        this.ext = aExt;
    }

    public byte getAttr() {
        return this.attr;
    }

    public void setAttr(byte aAttr) {
        this.attr = aAttr;
    }

    public byte getLcase() {
        return this.lcase;
    }

    public void setLcase(byte aLcase) {
        this.lcase = aLcase;
    }

    public int getCtimems() {
        return this.ctimems;
    }

    public void setCtimems(int aCtimems) {
        this.ctimems = aCtimems;
    }

    public int getCtime() {
        return this.ctime;
    }

    public void setCtime(int aCtime) {
        this.ctime = aCtime;
    }

    public int getCdate() {
        return this.cdate;
    }

    public void setCdate(int aCdate) {
        this.cdate = aCdate;
    }

    public int getAdate() {
        return this.adate;
    }

    public void setAdate(int aAdate) {
        this.adate = aAdate;
    }

    public int getStartHi() {
        return this.starthi;
    }

    public void setStartHi(int aStarthi) {
        this.starthi = aStarthi;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int aTime) {
        this.time = aTime;
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int aDate) {
        this.date = aDate;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int aStart) {
        this.start = aStart;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long aSize) {
        this.size = aSize;
    }

    public int getMode() {
        int mode = 0;
        byte attr = this.getAttr();
        mode = (attr & 0x10) != 0 ? (mode |= 0x4000) : (mode |= 0x8000);
        if ((attr & 1) == 0) {
            mode |= 0x92;
        }
        if ((attr & 2) == 0) {
            mode |= 0x100;
        }
        if ((attr & 4) == 0) {
            mode |= 0x20;
        }
        if ((attr & 0x20) == 0) {
            mode |= 4;
        }
        if ((attr & 8) != 0) {
            mode |= 1;
        }
        return mode;
    }

    public void setMode(int aMode) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long getNumLinks() {
        return 1L;
    }

    public void setNumLinks(long aNumLinks) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long getUserId() {
        return 0L;
    }

    public void setUserId(long aUserId) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long getGroupId() {
        return 0L;
    }

    public void setGroupId(long aGroupId) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long getAccessTime() {
        return this.date_dos2unix(0, this.getAdate());
    }

    public void setAccessTime(long aAccessTime) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long getModifyTime() {
        return this.date_dos2unix(this.getTime(), this.getDate());
    }

    public void setModifyTime(long aModifyTime) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long getChangedTime() {
        return this.date_dos2unix(this.getCtime(), this.getCdate());
    }

    public void setChangedTime(long aChangedTime) {
        throw new UnsupportedOperationException("Not supported.");
    }

    protected int date_dos2unix(int time, int date) {
        int month = (date >> 5) - 1 & 0xF;
        int year = date >> 9;
        int secs = (time & 0x1F) * 2 + 60 * (time >> 5 & 0x3F) + (time >> 11) * 3600 + 86400 * ((date & 0x1F) - 1 + day_n[month] + year / 4 + year * 365 - ((year & 3) == 0 && month < 2 ? 1 : 0) + 3653);
        return secs;
    }

    public byte getHashValue() {
        return this.hashValue;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String aLongName) {
        this.longName = aLongName;
    }

    public String getName() {
        String name = this.getLongName();
        if (name == null) {
            name = this.getShortName();
        }
        return name;
    }

    private void computeHash() {
        int i;
        this.hashValue = 0;
        for (i = 0; i < 8; ++i) {
            this.hashValue = (byte)(((this.hashValue & 0xFE) >> 1 | (this.hashValue & 1) << 7) & 0xFF);
            this.hashValue = (byte)(this.hashValue + this.name[i]);
        }
        for (i = 0; i < 3; ++i) {
            this.hashValue = (byte)(((this.hashValue & 0xFE) >> 1 | (this.hashValue & 1) << 7) & 0xFF);
            this.hashValue = (byte)(this.hashValue + this.ext[i]);
        }
    }

    public String getShortName() {
        String shortName = null;
        String trimmedExt = null;
        try {
            shortName = new String(this.name, "ISO-8859-1").trim();
            trimmedExt = new String(this.ext, "ISO-8859-1").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((this.getLcase() & 8) != 0) {
            shortName = shortName.toLowerCase();
        }
        if ((this.getLcase() & 0x10) != 0) {
            trimmedExt = trimmedExt.toLowerCase();
        }
        if (trimmedExt.length() > 0) {
            shortName = shortName + "." + trimmedExt;
        }
        return shortName;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        this.name = new byte[8];
        System.arraycopy(buffer, offset + 0, this.name, 0, 8);
        this.ext = new byte[3];
        System.arraycopy(buffer, offset + 8, this.ext, 0, 3);
        this.attr = buffer[11];
        this.lcase = buffer[12];
        this.ctimems = buffer[13];
        this.setCtime(FsUtils.getU16(buffer, offset + 14));
        this.setCdate(FsUtils.getU16(buffer, offset + 16));
        this.setAdate(FsUtils.getU16(buffer, offset + 18));
        this.setStartHi(FsUtils.getU16(buffer, offset + 20));
        this.setTime(FsUtils.getU16(buffer, offset + 22));
        this.setDate(FsUtils.getU16(buffer, offset + 24));
        this.setStart(FsUtils.getU16(buffer, offset + 26));
        this.setSize(FsUtils.getU32(buffer, offset + 28));
        this.computeHash();
    }
}

