/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.fatfs.FatDirEntry;
import rossi.fstools.fs.fatfs.VFatDirEntry;
import rossi.fstools.fs.fatfs.VFatProcessor;
import rossi.fstools.io.BlockPointerInputStream;

public class FatDirectory
implements Directory {
    private Map dirMap = new HashMap();
    private boolean atEOF = false;

    public FatDirectory(File file) throws IOException, FsException {
        this.load(file);
    }

    private void load(File file) throws IOException, FsException {
        int bytesRead;
        BlockPointerInputStream in = file.getData();
        int direntrySize = new FatDirEntry().getDataSize();
        byte[] buffer = new byte[direntrySize];
        VFatProcessor vfatsm = new VFatProcessor();
        while ((bytesRead = this.fillBuffer(in, buffer, 0)) >= direntrySize && buffer[0] != 0) {
            if ((buffer[0] & 0xFF) == 229) continue;
            if (buffer[11] == 15) {
                VFatDirEntry lfn = new VFatDirEntry();
                lfn.loadFromBuffer(buffer, 0);
                vfatsm.processLFNEntry(lfn);
                continue;
            }
            FatDirEntry dir = new FatDirEntry();
            dir.loadFromBuffer(buffer, 0);
            vfatsm.processDirEntry(dir);
            this.dirMap.put(dir.getName(), dir);
        }
        in.close();
    }

    private int fillBuffer(InputStream in, byte[] buffer, int startoffset) throws IOException {
        int totalBytesRead;
        int bytesRead;
        int bytesToRead = buffer.length;
        if (this.atEOF) {
            return 0;
        }
        for (totalBytesRead = startoffset; totalBytesRead < bytesToRead; totalBytesRead += bytesRead) {
            bytesRead = in.read(buffer, totalBytesRead, bytesToRead - totalBytesRead);
            if (bytesRead != -1) continue;
            this.atEOF = true;
            return totalBytesRead - startoffset;
        }
        return totalBytesRead - startoffset;
    }

    public Map getInodePtrMap() {
        return this.dirMap;
    }
}

