/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import java.util.ArrayList;
import java.util.List;
import rossi.fstools.fs.File;
import rossi.fstools.fs.fatfs.FatSuperBlock;
import rossi.fstools.io.BlockPointer;
import rossi.fstools.io.BlockPointerInputStream;
import rossi.fstools.io.BlockReader;

public class FatFile
implements File {
    protected List blkPointerList = new ArrayList();
    protected List slackList = new ArrayList();
    protected long size;
    protected long sizeRemaining;
    protected BlockReader reader;
    protected FatSuperBlock sb;

    public FatFile(FatSuperBlock sb, long fileSize, BlockReader reader) {
        this.size = fileSize;
        this.reader = reader;
        this.sb = sb;
        this.sizeRemaining = this.size;
    }

    public void add(int cluster) {
        BlockPointer bp;
        BlockPointer lastBp = null;
        int lastend = 0;
        int lastendoffset = 0;
        int sectorSize = this.sb.getSectorSize();
        int clusterSize = sectorSize * this.sb.getSectorsPerCluster();
        int curSize = this.sizeRemaining < (long)clusterSize ? (int)this.sizeRemaining : clusterSize;
        int blocknum = this.sb.getFirstDataSector() + (cluster - 2) * this.sb.getSectorsPerCluster();
        if (this.blkPointerList.size() != 0) {
            lastBp = (BlockPointer)this.blkPointerList.get(this.blkPointerList.size() - 1);
            lastend = lastBp.getBlockNum() + (lastBp.getOffset() + lastBp.getLength()) / lastBp.getBlockSize();
            lastendoffset = (lastBp.getOffset() + lastBp.getLength()) % lastBp.getBlockSize();
        }
        if (lastBp != null && lastend == blocknum && lastendoffset == 0) {
            lastBp.setLength(lastBp.getLength() + curSize);
        } else {
            bp = new BlockPointer();
            bp.setBlockNum(blocknum);
            bp.setOffset(0);
            bp.setLength(curSize);
            bp.setBlockSize(sectorSize);
            this.blkPointerList.add(bp);
        }
        if (curSize != clusterSize) {
            bp = new BlockPointer();
            bp.setBlockNum(blocknum + curSize / sectorSize);
            bp.setOffset(curSize % sectorSize);
            bp.setLength(clusterSize - curSize);
            bp.setBlockSize(sectorSize);
            this.slackList.add(bp);
        }
        this.sizeRemaining -= (long)curSize;
    }

    public BlockPointerInputStream getData() {
        return new BlockPointerInputStream(this.reader, this.blkPointerList);
    }

    public BlockPointerInputStream getSlack() {
        return new BlockPointerInputStream(this.reader, this.slackList);
    }
}

