/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import java.io.IOException;
import rossi.fstools.fs.Directory;
import rossi.fstools.fs.File;
import rossi.fstools.fs.FileSystem;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsObject;
import rossi.fstools.fs.Inode;
import rossi.fstools.fs.InodePtr;
import rossi.fstools.fs.SuperBlock;
import rossi.fstools.fs.fatfs.FatDirEntry;
import rossi.fstools.fs.fatfs.FatDirectory;
import rossi.fstools.fs.fatfs.FatFile;
import rossi.fstools.fs.fatfs.FatRootDirFile;
import rossi.fstools.fs.fatfs.FatSuperBlock;
import rossi.fstools.fs.fatfs.FatTable;
import rossi.fstools.io.BlockReader;

public class FatFileSystem
implements FileSystem {
    private BlockReader blockReader;
    private FatSuperBlock sb;
    private FatDirEntry rootDirEntry;
    private FatTable fatTable;
    private File rootDirFile;

    public SuperBlock open(BlockReader br) throws FsException, IOException {
        this.blockReader = br;
        br.setBlockSize(512);
        this.sb = new FatSuperBlock();
        this.sb.loadFromBuffer(br.getBlock(0), 0);
        br.setBlockSize(this.sb.getSectorSize());
        this.fatTable = new FatTable(this.sb, br);
        this.createRootInode();
        this.createRootDirFile();
        return this.sb;
    }

    private void createRootInode() {
        int i;
        byte[] nameprefix = new byte[8];
        byte[] ext = new byte[3];
        for (i = 0; i < nameprefix.length; ++i) {
            nameprefix[i] = 32;
        }
        for (i = 0; i < ext.length; ++i) {
            ext[i] = 32;
        }
        this.rootDirEntry = new FatDirEntry();
        this.rootDirEntry.setLongName("");
        this.rootDirEntry.setAttr((byte)16);
        this.rootDirEntry.setStart(0);
        this.rootDirEntry.setStartHi(0);
    }

    private void createRootDirFile() throws FsException, IOException {
        this.rootDirFile = this.sb.getFatBits() == 32 ? this.createFatFile((int)this.sb.getRootCluster(), Long.MAX_VALUE) : new FatRootDirFile(this.sb, this.blockReader);
    }

    public void close() throws IOException {
        this.blockReader.close();
    }

    public InodePtr getRootDir() {
        return this.rootDirEntry;
    }

    public Inode getInode(InodePtr ptr) throws FsException, IOException {
        return (Inode)((Object)ptr);
    }

    public File createFatFile(FatDirEntry inode) throws FsException, IOException {
        int startCluster = inode.getStart();
        if (this.sb.getFatBits() == 32) {
            startCluster |= inode.getStartHi() << 16;
        }
        long fileSize = inode.getSize();
        if (startCluster == 0) {
            if ((inode.getMode() & 0xF000) == 16384) {
                return this.rootDirFile;
            }
            return new FatFile(this.sb, 0L, this.blockReader);
        }
        if ((inode.getMode() & 0xF000) == 16384) {
            fileSize = Long.MAX_VALUE;
        }
        return this.createFatFile(startCluster, fileSize);
    }

    private File createFatFile(int startCluster, long fileSize) throws FsException, IOException {
        int cluster = startCluster;
        FatFile file = new FatFile(this.sb, fileSize, this.blockReader);
        do {
            file.add(cluster);
        } while (!this.fatTable.isEOF(cluster = this.fatTable.lookup(cluster)) && !this.fatTable.isBad(cluster));
        return file;
    }

    public Directory createFatDirectory(FatDirEntry inode) throws FsException, IOException {
        return new FatDirectory(this.createFatFile(inode));
    }

    public FsObject getObject(Inode inode) throws FsException, IOException {
        int fileType = inode.getMode() & 0xF000;
        switch (fileType) {
            case 16384: {
                return this.createFatDirectory((FatDirEntry)inode);
            }
            case 32768: {
                return this.createFatFile((FatDirEntry)inode);
            }
        }
        throw new FsException("Unsupported file type " + fileType);
    }
}

