/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import java.util.ArrayList;
import java.util.List;
import rossi.fstools.fs.File;
import rossi.fstools.fs.fatfs.FatDirEntry;
import rossi.fstools.fs.fatfs.FatSuperBlock;
import rossi.fstools.io.BlockPointer;
import rossi.fstools.io.BlockPointerInputStream;
import rossi.fstools.io.BlockReader;

public class FatRootDirFile
implements File {
    private List dataList;
    private List slackList;
    private BlockReader blockReader;

    public FatRootDirFile(FatSuperBlock sb, BlockReader blockReader) {
        this.blockReader = blockReader;
        this.dataList = new ArrayList();
        this.slackList = new ArrayList();
        int rootDirLen = sb.getRootDirEntries() * new FatDirEntry().getDataSize();
        BlockPointer bp = new BlockPointer();
        bp.setBlockNum(sb.getReservedSectors() + sb.getNumFATs() * sb.getFatLength());
        bp.setOffset(0);
        bp.setLength(rootDirLen);
        bp.setBlockSize(sb.getSectorSize());
        this.dataList.add(bp);
    }

    public BlockPointerInputStream getData() {
        return new BlockPointerInputStream(this.blockReader, this.dataList);
    }

    public BlockPointerInputStream getSlack() {
        return new BlockPointerInputStream(this.blockReader, this.slackList);
    }
}

