/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.SuperBlock;
import rossi.fstools.fs.fatfs.FatDirEntry;

public class FatSuperBlock
implements SuperBlock {
    protected byte[] bootStrap;
    protected String systemId;
    protected int sectorSize;
    protected int sectorsPerCluster;
    protected int reservedSectors;
    protected int numFATs;
    protected int rootDirEntries;
    protected int sectors;
    protected byte media;
    protected int fatLength;
    protected int sectorsPerTrack;
    protected int heads;
    protected long hiddenSectors;
    protected long totalSectors;
    protected long fat32Length;
    protected int flags;
    protected int version;
    protected long rootCluster;
    protected int infoSector;
    protected int backupBootSector;
    public static final int MAX_FAT12 = 4084;
    public static final int MAX_FAT16 = 65524;
    public static final int MAX_FAT32 = 0xFFFFFF4;
    private static final int DIRENTRY_SIZE = new FatDirEntry().getDataSize();

    public byte[] getBootStrap() {
        return this.bootStrap;
    }

    public void setBootStrap(byte[] aBootStrap) {
        this.bootStrap = aBootStrap;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String aSystemId) {
        this.systemId = aSystemId;
    }

    public int getSectorSize() {
        return this.sectorSize;
    }

    public void setSectorSize(int aSectorSize) {
        this.sectorSize = aSectorSize;
    }

    public int getSectorsPerCluster() {
        return this.sectorsPerCluster;
    }

    public void setSectorsPerCluster(int aSectorsPerCluster) {
        this.sectorsPerCluster = aSectorsPerCluster;
    }

    public int getReservedSectors() {
        return this.reservedSectors;
    }

    public void setReservedSectors(int aReservedSectors) {
        this.reservedSectors = aReservedSectors;
    }

    public int getNumFATs() {
        return this.numFATs;
    }

    public void setNumFATs(int aNumFATs) {
        this.numFATs = aNumFATs;
    }

    public int getRootDirEntries() {
        return this.rootDirEntries;
    }

    public void setRootDirEntries(int aRootDirEntries) {
        this.rootDirEntries = aRootDirEntries;
    }

    public int getSectors() {
        return this.sectors;
    }

    public void setSectors(int aSectors) {
        this.sectors = aSectors;
    }

    public byte getMedia() {
        return this.media;
    }

    public void setMedia(byte aMedia) {
        this.media = aMedia;
    }

    public int getFatLength() {
        return this.fatLength;
    }

    public void setFatLength(int aFatLength) {
        this.fatLength = aFatLength;
    }

    public int getSectorsPerTrack() {
        return this.sectorsPerTrack;
    }

    public void setSectorsPerTrack(int aSectorsPerTrack) {
        this.sectorsPerTrack = aSectorsPerTrack;
    }

    public int getHeads() {
        return this.heads;
    }

    public void setHeads(int aHeads) {
        this.heads = aHeads;
    }

    public long getHiddenSectors() {
        return this.hiddenSectors;
    }

    public void setHiddenSectors(long aHiddenSectors) {
        this.hiddenSectors = aHiddenSectors;
    }

    public long getTotalSectors() {
        return this.totalSectors;
    }

    public void setTotalSectors(long aTotalSectors) {
        this.totalSectors = aTotalSectors;
    }

    public long getFat32Length() {
        return this.fat32Length;
    }

    public void setFat32Length(long aFat32Length) {
        this.fat32Length = aFat32Length;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int aFlags) {
        this.flags = aFlags;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int aVersion) {
        this.version = aVersion;
    }

    public long getRootCluster() {
        return this.rootCluster;
    }

    public void setRootCluster(long aRootCluster) {
        this.rootCluster = aRootCluster;
    }

    public int getInfoSector() {
        return this.infoSector;
    }

    public void setInfoSector(int aInfoSector) {
        this.infoSector = aInfoSector;
    }

    public int getBackupBootSector() {
        return this.backupBootSector;
    }

    public void setBackupBootSector(int aBackupBootSector) {
        this.backupBootSector = aBackupBootSector;
    }

    public long getNumSectors() {
        long sectors = this.getSectors();
        if (sectors == 0L) {
            sectors = this.getTotalSectors();
        }
        return sectors;
    }

    public long getNumClusters() {
        long totalSectors = this.getNumSectors();
        int fatSectors = this.getFatLength() == 0 && this.getFat32Length() > 0L ? (int)this.getFat32Length() : this.getFatLength();
        int rootDirSectors = this.getRootDirEntries() * DIRENTRY_SIZE / this.getSectorSize();
        long dataAreaSectors = totalSectors - (long)this.getReservedSectors() - (long)rootDirSectors - (long)(fatSectors *= this.getNumFATs());
        return dataAreaSectors / (long)this.getSectorsPerCluster();
    }

    public int getFatBits() {
        if (this.getFatLength() == 0 && this.getFat32Length() > 0L) {
            return 32;
        }
        if (this.getNumClusters() > 4084L) {
            return 16;
        }
        return 12;
    }

    public int getFirstDataSector() {
        int fatLength = this.getFatBits() == 32 ? (int)this.getFat32Length() : this.getFatLength();
        int rootDirLen = this.getRootDirEntries() * DIRENTRY_SIZE / this.getSectorSize();
        int dataArea = this.getReservedSectors() + this.getNumFATs() * fatLength + rootDirLen;
        return dataArea;
    }

    public int getDataSize() {
        return 512;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        this.bootStrap = new byte[3];
        System.arraycopy(buffer, offset + 0, this.bootStrap, 0, 3);
        try {
            this.systemId = new String(buffer, offset + 3, 8, "ISO-8859-1");
        }
        catch (Exception ex) {
            FsException fsex = new FsException(ex.getMessage());
            fsex.initCause(ex);
            throw fsex;
        }
        this.setSectorSize(FsUtils.getU16(buffer, offset + 11));
        this.setSectorsPerCluster(buffer[13]);
        this.setReservedSectors(FsUtils.getU16(buffer, offset + 14));
        this.setNumFATs(buffer[16]);
        this.setRootDirEntries(FsUtils.getU16(buffer, offset + 17));
        this.setSectors(FsUtils.getU16(buffer, offset + 19));
        this.setMedia(buffer[21]);
        this.setFatLength(FsUtils.getU16(buffer, offset + 22));
        this.setSectorsPerTrack(FsUtils.getU16(buffer, offset + 24));
        this.setHeads(FsUtils.getU16(buffer, offset + 26));
        this.setHiddenSectors(FsUtils.getU32(buffer, offset + 28));
        this.setTotalSectors(FsUtils.getU32(buffer, offset + 32));
        this.setFat32Length(FsUtils.getU32(buffer, offset + 36));
        this.setFlags(FsUtils.getU16(buffer, offset + 40));
        this.setVersion(FsUtils.getU16(buffer, offset + 42));
        this.setRootCluster(FsUtils.getU32(buffer, offset + 44));
        this.setInfoSector(FsUtils.getU16(buffer, offset + 48));
        this.setBackupBootSector(FsUtils.getU16(buffer, offset + 50));
        if (this.getReservedSectors() == 0) {
            throw new FsException("Invalid number of reserved sectors.\n");
        }
        if (this.getNumFATs() == 0) {
            throw new FsException("Invalid number of FATs.\n");
        }
        if (this.getSectorsPerTrack() == 0) {
            throw new FsException("Invalid sectors per track.\n");
        }
        if (this.getHeads() == 0) {
            throw new FsException("Invalid number of heads.\n");
        }
        if (this.getHeads() == 0) {
            throw new FsException("Invalid number of heads.\n");
        }
        if (this.getSectorSize() == 0 || (this.getSectorSize() & this.getSectorSize() - 1) != 0 || this.getSectorSize() < 512) {
            throw new FsException("Invalid logical sector size.\n");
        }
        if (this.getSectorsPerCluster() == 0 || (this.getSectorsPerCluster() & this.getSectorsPerCluster() - 1) != 0) {
            throw new FsException("Invalid sectors per cluster.\n");
        }
        int dirEntriesPerSector = this.getSectorSize() / DIRENTRY_SIZE;
        if (this.getRootDirEntries() % dirEntriesPerSector != 0) {
            throw new FsException("Invalid number of root directory entries.\n");
        }
    }
}

