/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import java.io.IOException;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.fatfs.FatSuperBlock;
import rossi.fstools.io.BlockReader;

public class FatTable {
    private FatSuperBlock sb;
    private BlockReader blockReader;
    private int eof;
    private int bad;
    private int fatStart;
    private static int EOF_FAT12 = 4088;
    private static int EOF_FAT16 = 65528;
    private static int EOF_FAT32 = 0xFFFFFF8;
    private static int BAD_FAT12 = 4087;
    private static int BAD_FAT16 = 65527;
    private static int BAD_FAT32 = 0xFFFFFF7;

    public FatTable(FatSuperBlock sb, BlockReader br) {
        this.sb = sb;
        this.blockReader = br;
        if (sb.getFatBits() == 32) {
            this.eof = EOF_FAT32;
            this.bad = BAD_FAT32;
        } else if (sb.getFatBits() == 16) {
            this.eof = EOF_FAT16;
            this.bad = BAD_FAT16;
        } else {
            this.eof = EOF_FAT12;
            this.bad = BAD_FAT12;
        }
        this.fatStart = sb.getReservedSectors();
    }

    public boolean isEOF(int cluster) {
        return (cluster & this.eof) == this.eof;
    }

    public boolean isBad(int cluster) {
        return cluster == this.bad;
    }

    public boolean isFree(int cluster) {
        return cluster == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int lookup(int cluster) throws FsException, IOException {
        void var6_6;
        int tmpcluster = this.sb.getFatBits() == 12 ? cluster & 0xFFFFFFFE : cluster;
        int sector = (int)((long)tmpcluster * (long)this.sb.getFatBits()) / (this.sb.getSectorSize() * 8);
        int sectorOffset = (int)((long)tmpcluster * (long)this.sb.getFatBits() - (long)(sector * this.sb.getSectorSize() * 8)) / this.sb.getFatBits();
        byte[] buffer = this.blockReader.getBlock(this.fatStart + sector);
        switch (this.sb.getFatBits()) {
            case 32: {
                int result = (int)FsUtils.getU32(buffer, sectorOffset * 4);
                break;
            }
            case 16: {
                int result = FsUtils.getU16(buffer, sectorOffset * 2);
                break;
            }
            case 12: {
                int result;
                int sectorAlignment = (int)((long)sector * (long)this.sb.getSectorSize()) % 3;
                sectorAlignment = (3 - sectorAlignment) % 3;
                int firstByte = sectorOffset / 2 * 3 + sectorAlignment;
                if (firstByte + 3 >= buffer.length) {
                    byte[] newbuffer = new byte[buffer.length * 2];
                    System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
                    System.arraycopy(this.blockReader.getBlock(this.fatStart + sector + 1), 0, newbuffer, buffer.length, buffer.length);
                    buffer = newbuffer;
                }
                if (cluster % 2 == 0) {
                    result = buffer[firstByte] & 0xFF | (buffer[firstByte + 1] & 0xF) << 8;
                    break;
                }
                result = (buffer[firstByte + 1] & 0xF0) >> 4 | (buffer[firstByte + 2] & 0xFF) << 4;
                break;
            }
            default: {
                throw new FsException("Invalid number of bits per fat entry.");
            }
        }
        return (int)var6_6;
    }
}

