/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;

public class VFatDirEntry
implements DiskStructure {
    protected byte sequence;
    protected String name;
    protected byte attr;
    protected byte hashValue;
    protected int start;

    public int getDataSize() {
        return 32;
    }

    public byte getSequence() {
        return this.sequence;
    }

    public void setSequence(byte aSequence) {
        this.sequence = aSequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public byte getAttr() {
        return this.attr;
    }

    public void setAttr(byte aAttr) {
        this.attr = aAttr;
    }

    public byte getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(byte aHashValue) {
        this.hashValue = aHashValue;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int aStart) {
        this.start = aStart;
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        int i;
        this.sequence = buffer[offset + 0];
        char[] namebuffer = new char[13];
        for (i = 0; i < 5; ++i) {
            namebuffer[i] = (char)(buffer[offset + 1 + i * 2] & 0xFF | (buffer[offset + 1 + i * 2 + 1] & 0xFF) << 8);
        }
        for (i = 0; i < 6; ++i) {
            namebuffer[i + 5] = (char)(buffer[offset + 14 + i * 2] & 0xFF | (buffer[offset + 14 + i * 2 + 1] & 0xFF) << 8);
        }
        for (i = 0; i < 2; ++i) {
            namebuffer[i + 11] = (char)(buffer[offset + 28 + i * 2] & 0xFF | (buffer[offset + 28 + i * 2 + 1] & 0xFF) << 8);
        }
        this.name = new String(namebuffer);
        int zeroidx = this.name.indexOf(0);
        if (zeroidx > 0) {
            this.name = this.name.substring(0, zeroidx);
        }
        this.attr = buffer[11];
        if (this.attr != 15) {
            throw new FsException("Invalid attribute byte.  0x" + Integer.toString(this.attr & 0xFF, 16));
        }
        this.hashValue = buffer[13];
        this.setStart(FsUtils.getU16(buffer, offset + 26));
    }
}

