/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.fatfs;

import java.util.Stack;
import rossi.fstools.fs.fatfs.FatDirEntry;
import rossi.fstools.fs.fatfs.VFatDirEntry;

public class VFatProcessor {
    private Stack lfnStack = new Stack();
    private byte hashValue = 0;
    private boolean lfnReady = false;

    public void processLFNEntry(VFatDirEntry vfat) {
        if ((vfat.getSequence() & 0x40) != 0) {
            this.lfnStack.clear();
            this.lfnReady = false;
        }
        if ((vfat.getSequence() & 0x3F) == 1) {
            this.hashValue = vfat.getHashValue();
            this.lfnReady = true;
        }
        this.lfnStack.push(vfat);
    }

    public void processDirEntry(FatDirEntry dir) {
        if (this.lfnReady && dir.getHashValue() == this.hashValue) {
            dir.setLongName(this.getLongName());
        }
    }

    private String getLongName() {
        StringBuffer sb = new StringBuffer();
        while (!this.lfnStack.empty()) {
            sb.append(((VFatDirEntry)this.lfnStack.pop()).getName());
        }
        this.lfnReady = false;
        return sb.toString();
    }
}

