/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.Item;
import rossi.fstools.fs.reiserfs.ItemHead;
import rossi.fstools.fs.reiserfs.LeafNode;

public class IndirectItem
extends Item {
    protected int[] ptrs;

    public IndirectItem(byte[] buffer, int bufferOffset, LeafNode block, ItemHead header) throws FsException {
        super(buffer, bufferOffset, block, header);
        this.load();
    }

    public int numEntries() {
        return this.header.getItemLen() / 4;
    }

    public int[] getEntries() {
        return this.ptrs;
    }

    protected void load() throws FsException {
        this.ptrs = new int[this.numEntries()];
        for (int i = 0; i < this.numEntries(); ++i) {
            this.ptrs[i] = (int)FsUtils.getU32(this.buffer, this.bufferOffset + this.header.getItemLocation() + i * 4);
        }
    }
}

