/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.reiserfs.DiskChild;
import rossi.fstools.fs.reiserfs.FBlock;
import rossi.fstools.fs.reiserfs.Key;
import rossi.fstools.fs.reiserfs.KeyV1;
import rossi.fstools.fs.reiserfs.ReiserSuperBlock;

public class InternalNode
extends FBlock {
    protected Key[] keys;
    protected DiskChild[] ptrs;
    protected byte[] freeSpaceData;

    public InternalNode(ReiserSuperBlock sb, int blocknum) {
        super(sb, blocknum);
    }

    public Key[] getKeys() {
        return this.keys;
    }

    public void setKeys(Key[] aKeys) {
        this.keys = aKeys;
    }

    public DiskChild[] getPtrs() {
        return this.ptrs;
    }

    public void setPtrs(DiskChild[] aPtrs) {
        this.ptrs = aPtrs;
    }

    public byte[] getFreeSpaceData() {
        return this.freeSpaceData;
    }

    public void setFreeSpaceData(byte[] aFreeSpace) {
        this.freeSpaceData = aFreeSpace;
    }

    public DiskChild getPointerForKey(Key k) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (k.compareTo(this.keys[i]) <= 0) continue;
            return this.ptrs[i];
        }
        return this.ptrs[this.keys.length];
    }

    public void loadFromBuffer(byte[] buffer, int offset) throws FsException {
        int i;
        super.loadFromBuffer(buffer, offset);
        this.keys = new Key[this.getNumItems()];
        this.ptrs = new DiskChild[this.getNumItems() + 1];
        int keysize = new KeyV1().getDataSize();
        int ptrsize = new DiskChild().getDataSize();
        int ptroffset = offset + 24 + keysize * this.getNumItems();
        int keyoffset = offset + 24;
        for (i = 0; i < this.getNumItems(); ++i) {
            this.keys[i] = Key.createKeyFromBuffer(buffer, keyoffset + i * keysize);
        }
        for (i = 0; i <= this.getNumItems(); ++i) {
            DiskChild child = new DiskChild();
            child.loadFromBuffer(buffer, ptroffset + i * ptrsize);
            this.ptrs[i] = child;
        }
        int endoffset = ptroffset + (this.getNumItems() + 1) * ptrsize;
        int freesize = this.getDataSize() - endoffset;
        this.freeSpaceData = new byte[freesize];
        System.arraycopy(buffer, endoffset, this.freeSpaceData, 0, freesize);
    }
}

