/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.DiskStructure;
import rossi.fstools.fs.FsException;
import rossi.fstools.fs.InodePtr;
import rossi.fstools.fs.reiserfs.KeyV1;
import rossi.fstools.fs.reiserfs.KeyV2;

public abstract class Key
implements DiskStructure,
InodePtr,
Comparable,
Cloneable {
    public static final int KEY_FORMAT_3_5 = 0;
    public static final int KEY_FORMAT_3_6 = 1;
    public static final int TYPE_STAT_DATA = 0;
    public static final int TYPE_INDIRECT = 1;
    public static final int TYPE_DIRECT = 2;
    public static final int TYPE_DIRENTRY = 3;
    public static final int TYPE_MAXTYPE = 3;
    protected long parentDirId;
    protected long objectId;
    protected long offset;
    protected int type;

    public int getDataSize() {
        return 16;
    }

    public long getParentDirId() {
        return this.parentDirId;
    }

    public void setParentDirId(long aParentDirId) {
        this.parentDirId = aParentDirId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long aObjectId) {
        this.objectId = aObjectId;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long aOffset) {
        this.offset = aOffset;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public static Key createKeyFromBuffer(byte[] buffer, int blkoffset) throws FsException {
        try {
            KeyV2 k2 = new KeyV2();
            k2.loadFromBuffer(buffer, blkoffset);
            return k2;
        }
        catch (FsException ex) {
            KeyV1 k1 = new KeyV1();
            k1.loadFromBuffer(buffer, blkoffset);
            return k1;
        }
    }

    public int compareTo(Object other) {
        Key otherKey = (Key)other;
        if (this.parentDirId > otherKey.parentDirId) {
            return -1;
        }
        if (this.parentDirId < otherKey.parentDirId) {
            return 1;
        }
        if (this.objectId > otherKey.objectId) {
            return -1;
        }
        if (this.objectId < otherKey.objectId) {
            return 1;
        }
        if (this.offset > otherKey.offset) {
            return -1;
        }
        if (this.offset < otherKey.offset) {
            return 1;
        }
        if (this.type > otherKey.type) {
            return -1;
        }
        if (this.type < otherKey.type) {
            return 1;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

