/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.Key;

public class KeyV1
extends Key {
    public static long V1_SD_UNIQUENESS = 0L;
    public static long V1_INDIRECT_UNIQUENESS = 0xFFFFFFFEL;
    public static long V1_DIRECT_UNIQUENESS = 0xFFFFFFFFL;
    public static long V1_DIRENTRY_UNIQUENESS = 500L;

    public void loadFromBuffer(byte[] buffer, int blkoffset) throws FsException {
        this.setParentDirId(FsUtils.getU32(buffer, blkoffset + 0));
        this.setObjectId(FsUtils.getU32(buffer, blkoffset + 4));
        this.setOffset(FsUtils.getU32(buffer, blkoffset + 8));
        long uniq = FsUtils.getU32(buffer, blkoffset + 12);
        if (uniq == V1_SD_UNIQUENESS) {
            this.setType(0);
            return;
        }
        if (uniq == V1_INDIRECT_UNIQUENESS) {
            this.setType(1);
            return;
        }
        if (uniq == V1_DIRECT_UNIQUENESS) {
            this.setType(2);
            return;
        }
        if (uniq == V1_DIRENTRY_UNIQUENESS) {
            this.setType(3);
            return;
        }
        throw new FsException("Unknown uniqueness on format 3.5 key: 0x" + Long.toHexString(uniq));
    }
}

