/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.FsException;
import rossi.fstools.fs.FsUtils;
import rossi.fstools.fs.reiserfs.Key;

public class KeyV2
extends Key {
    private static final FsException invalidex = new FsException("Invalid type for format 3.6 key");

    public void loadFromBuffer(byte[] buffer, int blkoffset) throws FsException {
        this.setParentDirId(FsUtils.getU32(buffer, blkoffset + 0));
        this.setObjectId(FsUtils.getU32(buffer, blkoffset + 4));
        long lowoffset = FsUtils.getU32(buffer, blkoffset + 8);
        long highoffset = FsUtils.getU32(buffer, blkoffset + 12);
        int type = (int)((highoffset & 0xFFFFFFFFF0000000L) >> 28);
        if (type != 1 && type != 2 && type != 3) {
            throw invalidex;
        }
        long off = (highoffset & 0xFFFFFFFL) << 32;
        this.setOffset(off |= lowoffset);
        this.setType(type);
    }
}

