/*
 * Decompiled with CFR 0.152.
 */
package rossi.fstools.fs.reiserfs;

import rossi.fstools.fs.Device;
import rossi.fstools.fs.reiserfs.StatDataItem;

public class ReiserDevice
implements Device {
    private boolean blockDev = false;
    private boolean charDev = false;
    private int major;
    private int minor;

    public ReiserDevice(StatDataItem inode) {
        if ((inode.getMode() & 0xF000) == 8192) {
            this.charDev = true;
        }
        if ((inode.getMode() & 0xF000) == 24576) {
            this.blockDev = true;
        }
        this.major = (inode.getRDev() & 0xFF00) >> 8;
        this.minor = inode.getRDev() & 0xFF;
    }

    public boolean isBlockDev() {
        return this.blockDev;
    }

    public boolean isCharDev() {
        return this.charDev;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

